/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp;

import com.zx.sms.codec.smpp.TlvConvertException;
import com.zx.sms.common.util.ByteArrayUtil;
import com.zx.sms.common.util.HexUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class Tlv
implements Serializable {
    private final short tag;
    private final byte[] value;
    private String tagName;

    public Tlv(short tag, byte[] value) {
        this(tag, value, null);
    }

    public Tlv(short tag, byte[] value, String tagName) {
        this.tag = tag;
        this.value = value;
        this.tagName = tagName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String value) {
        this.tagName = value;
    }

    public short getTag() {
        return this.tag;
    }

    public int getUnsignedLength() {
        return this.value == null ? 0 : this.value.length;
    }

    public short getLength() {
        return (short)this.getUnsignedLength();
    }

    public byte[] getValue() {
        return this.value;
    }

    public int calculateByteSize() {
        return 4 + this.getUnsignedLength();
    }

    public String getValueAsString() throws TlvConvertException {
        return this.getValueAsString("ISO-8859-1");
    }

    public String getValueAsString(String charsetName) throws TlvConvertException {
        if (this.value == null) {
            return null;
        }
        if (this.value.length == 0) {
            return "";
        }
        int len = this.value.length;
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] != 0) continue;
            len = i;
            break;
        }
        try {
            return new String(this.value, 0, len, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new TlvConvertException("String", "unsupported charset " + e.getMessage());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(40);
        if (this.tagName != null) {
            buffer.append(this.tagName);
        } else {
            buffer.append("tlv");
        }
        buffer.append(": 0x");
        buffer.append(HexUtil.toHexString(this.tag));
        buffer.append(" 0x");
        buffer.append(HexUtil.toHexString((short)this.getUnsignedLength()));
        buffer.append(" [");
        HexUtil.appendHexString(buffer, this.value);
        buffer.append("]");
        return buffer.toString();
    }

    public byte getValueAsByte() throws TlvConvertException {
        try {
            return ByteArrayUtil.toByte(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("byte", e.getMessage());
        }
    }

    public short getValueAsUnsignedByte() throws TlvConvertException {
        try {
            return ByteArrayUtil.toUnsignedByte(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("unsigned byte", e.getMessage());
        }
    }

    public short getValueAsShort() throws TlvConvertException {
        try {
            return ByteArrayUtil.toShort(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("short", e.getMessage());
        }
    }

    public int getValueAsUnsignedShort() throws TlvConvertException {
        try {
            return ByteArrayUtil.toUnsignedShort(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("unsigned short", e.getMessage());
        }
    }

    public int getValueAsInt() throws TlvConvertException {
        try {
            return ByteArrayUtil.toInt(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("int", e.getMessage());
        }
    }

    public long getValueAsUnsignedInt() throws TlvConvertException {
        try {
            return ByteArrayUtil.toUnsignedInt(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("unsigned int", e.getMessage());
        }
    }

    public long getValueAsLong() throws TlvConvertException {
        try {
            return ByteArrayUtil.toLong(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("long", e.getMessage());
        }
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (this == t) {
            return true;
        }
        Tlv other = (Tlv)t;
        return other.tag == this.tag && Arrays.equals(other.value, this.value);
    }

    public int hashCode() {
        int hash = 42;
        hash = 31 * hash + this.tag;
        hash = 31 * hash + Arrays.hashCode(this.value);
        return hash;
    }
}

