/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp.msg;

import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.codec.smpp.Address;
import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.SmppInvalidArgumentException;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.DeliverSmReceipt;
import com.zx.sms.codec.smpp.msg.PduRequest;
import com.zx.sms.codec.smpp.msg.PduResponse;
import com.zx.sms.common.util.ByteBufUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.HexUtil;
import com.zx.sms.common.util.PduUtil;
import io.netty.buffer.ByteBuf;
import org.marre.sms.SmppSmsDcs;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsMsgClass;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsTextMessage;

public abstract class BaseSm<R extends PduResponse>
extends PduRequest<R> {
    protected String serviceType;
    protected Address sourceAddress;
    protected Address destAddress;
    protected byte esmClass = 0;
    private byte protocolId = 0;
    private byte priority = 0;
    private String scheduleDeliveryTime = "";
    private String validityPeriod = "";
    protected byte registeredDelivery = 1;
    private byte replaceIfPresent = 0;
    protected byte dataCoding = 0;
    private byte defaultMsgId = 0;
    private byte[] shortMessage;
    private short msglength;
    private SmsMessage smsMsg;
    private UniqueLongMsgId uniqueLongMsgId;

    public BaseSm(int commandId, String name) {
        super(commandId, name);
    }

    public short getMsglength() {
        return this.msglength;
    }

    public void setMsglength(short msglength) {
        this.msglength = msglength;
    }

    public byte[] getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(byte[] value) throws SmppInvalidArgumentException {
        if (value != null && value.length > 255) {
            throw new SmppInvalidArgumentException("A short message in a PDU can only be a max of 255 bytes [actual=" + value.length + "]; use optional parameter message_payload as an alternative");
        }
        this.shortMessage = value;
    }

    public byte getReplaceIfPresent() {
        return this.replaceIfPresent;
    }

    public void setReplaceIfPresent(byte value) {
        this.replaceIfPresent = value;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(byte value) {
        this.dataCoding = value;
    }

    public byte getDefaultMsgId() {
        return this.defaultMsgId;
    }

    public void setDefaultMsgId(byte value) {
        this.defaultMsgId = value;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte value) {
        this.registeredDelivery = value;
    }

    public String getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(String value) {
        this.validityPeriod = value;
    }

    public String getScheduleDeliveryTime() {
        return this.scheduleDeliveryTime;
    }

    public void setScheduleDeliveryTime(String value) {
        this.scheduleDeliveryTime = value;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte value) {
        this.priority = value;
    }

    public byte getEsmClass() {
        return this.esmClass;
    }

    public void setEsmClass(byte value) {
        this.esmClass = value;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(byte value) {
        this.protocolId = value;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public boolean isReport() {
        return this instanceof DeliverSmReceipt;
    }

    public void setServiceType(String value) {
        this.serviceType = value;
    }

    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Address value) {
        this.sourceAddress = value;
    }

    public Address getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(Address value) {
        this.destAddress = value;
    }

    protected UniqueLongMsgId getUniqueLongMsgId() {
        return this.uniqueLongMsgId;
    }

    protected void setUniqueLongMsgId(UniqueLongMsgId uniqueLongMsgId) {
        this.uniqueLongMsgId = uniqueLongMsgId;
    }

    public SmsMessage getSmsMessage() {
        return this.smsMsg;
    }

    public void setSmsMsg(SmsMessage smsMsg) {
        this.smsMsg = smsMsg;
    }

    public void setSmsMsg(String smsMsg) {
        this.smsMsg = SmsPduUtil.hasUnGsmchar(smsMsg) ? new SmsTextMessage(smsMsg, SmppSmsDcs.getGeneralDataCodingDcs(SmsAlphabet.UCS2, SmsMsgClass.CLASS_UNKNOWN)) : new SmsTextMessage(smsMsg, SmppSmsDcs.getGeneralDataCodingDcs(SmsAlphabet.GSM, SmsMsgClass.CLASS_UNKNOWN));
    }

    public void setSmsMsg(String smsMsg, SmsAlphabet defaultAlp) {
        if (SmsAlphabet.GSM == defaultAlp) {
            this.setSmsMsg(smsMsg);
        } else {
            this.smsMsg = SmsTextMessage.haswidthChar(smsMsg) ? new SmsTextMessage(smsMsg, SmppSmsDcs.getGeneralDataCodingDcs(SmsAlphabet.UCS2, SmsMsgClass.CLASS_UNKNOWN)) : new SmsTextMessage(smsMsg, new SmppSmsDcs(0, SmsAlphabet.ASCII));
        }
    }

    public String getMsgContent() {
        if (this.smsMsg instanceof SmsMessage) {
            return this.smsMsg.toString();
        }
        if (this.shortMessage != null && this.shortMessage.length > 0) {
            LongMessageFrame frame = this.doGenerateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    @Override
    public void readBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.serviceType = ByteBufUtil.readNullTerminatedString(buffer);
        this.sourceAddress = ByteBufUtil.readAddress(buffer);
        this.destAddress = ByteBufUtil.readAddress(buffer);
        this.esmClass = buffer.readByte();
        this.protocolId = buffer.readByte();
        this.priority = buffer.readByte();
        this.scheduleDeliveryTime = ByteBufUtil.readNullTerminatedString(buffer);
        this.validityPeriod = ByteBufUtil.readNullTerminatedString(buffer);
        this.registeredDelivery = buffer.readByte();
        this.replaceIfPresent = buffer.readByte();
        this.dataCoding = buffer.readByte();
        this.defaultMsgId = buffer.readByte();
        this.msglength = buffer.readUnsignedByte();
        this.shortMessage = new byte[this.msglength];
        buffer.readBytes(this.shortMessage);
    }

    @Override
    public int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.serviceType);
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.sourceAddress);
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.destAddress);
        bodyLength += 3;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.scheduleDeliveryTime);
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.validityPeriod);
        bodyLength += 5;
        return bodyLength += this.getShortMessage().length;
    }

    @Override
    public void writeBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        ByteBufUtil.writeNullTerminatedString(buffer, this.serviceType);
        ByteBufUtil.writeAddress(buffer, this.sourceAddress);
        ByteBufUtil.writeAddress(buffer, this.destAddress);
        buffer.writeByte((int)this.esmClass);
        buffer.writeByte((int)this.protocolId);
        buffer.writeByte((int)this.priority);
        ByteBufUtil.writeNullTerminatedString(buffer, this.scheduleDeliveryTime);
        ByteBufUtil.writeNullTerminatedString(buffer, this.validityPeriod);
        buffer.writeByte((int)this.registeredDelivery);
        buffer.writeByte((int)this.replaceIfPresent);
        buffer.writeByte((int)this.dataCoding);
        buffer.writeByte((int)this.defaultMsgId);
        buffer.writeByte((int)((byte)this.getMsglength()));
        if (this.shortMessage != null) {
            buffer.writeBytes(this.shortMessage);
        }
    }

    protected BaseSm doGenerateMessage(LongMessageFrame frame) throws Exception {
        BaseSm requestMessage = (BaseSm)this.clone();
        byte old = requestMessage.getEsmClass();
        requestMessage.setEsmClass((byte)(frame.getTpudhi() << 6 | old));
        requestMessage.setDataCoding(frame.getMsgfmt().getValue());
        requestMessage.setMsglength(frame.getMsgLength());
        requestMessage.setShortMessage(frame.getMsgContentBytes());
        if (frame.getPknumber() != 1) {
            requestMessage.setSequenceNumber(DefaultSequenceNumberUtil.getSequenceNo());
        }
        requestMessage.setSmsMsg((SmsMessage)null);
        return requestMessage;
    }

    private short getTpUdhI() {
        return (short)(this.getEsmClass() >> 6 & 1);
    }

    protected LongMessageFrame doGenerateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getProtocolId());
        frame.setTpudhi(this.getTpUdhI());
        frame.setMsgfmt(new SmppSmsDcs(this.getDataCoding()));
        frame.setMsgContentBytes(this.getShortMessage());
        frame.setMsgLength(this.getMsglength());
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public void appendBodyToString(StringBuilder buffer) {
        buffer.append("(serviceType [");
        buffer.append(this.serviceType);
        buffer.append("] sourceAddr [");
        buffer.append(this.sourceAddress);
        buffer.append("] destAddr [");
        buffer.append(this.destAddress);
        buffer.append("] esmCls [0x");
        buffer.append(HexUtil.toHexString(this.esmClass));
        buffer.append("] regDlvry [0x");
        buffer.append(HexUtil.toHexString(this.registeredDelivery));
        buffer.append("] dcs [0x");
        buffer.append(HexUtil.toHexString(this.dataCoding));
        buffer.append("] message [");
        buffer.append(this.getMsgContent());
        buffer.append("])");
    }
}

