/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp.msg;

import com.zx.sms.codec.smpp.SmppInvalidArgumentException;
import com.zx.sms.codec.smpp.msg.DeliverSm;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliverSmReceipt
extends DeliverSm {
    private static final Logger logger = LoggerFactory.getLogger(DeliverSmReceipt.class);
    private static final long serialVersionUID = 4411244865862324858L;
    private String id;
    private String sub;
    private String dlvrd;
    private String submit_date;
    private String done_date;
    private String stat;
    private String err;
    private String text;
    private Map<String, String> reportKV;

    public String getReportKV(String key) {
        return this.nvl(this.reportKV.get(key));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getDlvrd() {
        return this.dlvrd;
    }

    public void setDlvrd(String dlvrd) {
        this.dlvrd = dlvrd;
    }

    public String getSubmit_date() {
        return this.submit_date;
    }

    public void setSubmit_date(String submit_date) {
        this.submit_date = submit_date;
    }

    public String getDone_date() {
        return this.done_date;
    }

    public void setDone_date(String done_date) {
        this.done_date = done_date;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getErr() {
        return this.err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean isReport() {
        return true;
    }

    @Override
    public byte getEsmClass() {
        return 4;
    }

    @Override
    public void setShortMessage(byte[] value) throws SmppInvalidArgumentException {
        try {
            this.reportKV = this.parseReport(value);
            this.id = this.nvl(this.reportKV.get("id"));
            this.sub = this.nvl(this.reportKV.get("sub"));
            this.dlvrd = this.nvl(this.reportKV.get("dlvrd"));
            this.submit_date = this.nvl(this.reportKV.get("submitdate"));
            this.done_date = this.nvl(this.reportKV.get("donedate"));
            this.stat = this.nvl(this.reportKV.get("stat"));
            this.err = this.nvl(this.reportKV.get("err"));
            this.text = this.nvl(this.reportKV.get("text"));
        }
        catch (Exception e) {
            logger.error(new String(value), (Throwable)e);
        }
        super.setShortMessage(value);
    }

    @Override
    public byte[] getShortMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("id:").append(this.id);
        if (StringUtils.isNotBlank((CharSequence)this.sub)) {
            sb.append(" sub:").append(this.sub);
        }
        if (StringUtils.isNotBlank((CharSequence)this.dlvrd)) {
            sb.append(" dlvrd:").append(this.dlvrd);
        }
        if (StringUtils.isNotBlank((CharSequence)this.submit_date)) {
            sb.append(" submit date:").append(this.submit_date);
        }
        if (StringUtils.isNotBlank((CharSequence)this.done_date)) {
            sb.append(" done date:").append(this.done_date);
        }
        if (StringUtils.isNotBlank((CharSequence)this.stat)) {
            sb.append(" stat:").append(this.stat);
        }
        if (StringUtils.isNotBlank((CharSequence)this.err)) {
            sb.append(" err:").append(this.err);
        }
        if (StringUtils.isNotBlank((CharSequence)this.text)) {
            sb.append(" text:").append(this.text);
        }
        try {
            byte[] shortMessage = sb.toString().getBytes("ISO-8859-1");
            return shortMessage;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new byte[0];
        }
    }

    private Map<String, String> parseReport(byte[] value) {
        HashMap<String, String> kv = new HashMap<String, String>();
        boolean parseKeyName = true;
        StringBuffer temp = new StringBuffer();
        String keyName = "";
        String keyValue = "";
        for (byte c : value) {
            if (parseKeyName) {
                if (' ' == (char)c) continue;
                if (':' == (char)c) {
                    keyName = temp.toString();
                    temp.setLength(0);
                    parseKeyName = false;
                    continue;
                }
                temp.append((char)c);
                continue;
            }
            if (' ' == (char)c) {
                keyValue = temp.toString();
                temp.setLength(0);
                parseKeyName = true;
                kv.put(keyName.toLowerCase(), keyValue);
                keyName = "";
                keyValue = "";
                continue;
            }
            temp.append((char)c);
        }
        if (temp.length() > 0) {
            if (!parseKeyName) {
                kv.put(keyName.toLowerCase(), temp.toString());
            } else {
                kv.put(temp.toString(), "");
            }
        }
        return kv;
    }

    private String nvl(String k) {
        return k == null ? "" : k;
    }
}

