/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp.msg;

import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.PduResponse;
import com.zx.sms.common.util.ByteBufUtil;
import com.zx.sms.common.util.HexUtil;
import com.zx.sms.common.util.PduUtil;
import io.netty.buffer.ByteBuf;

public class QuerySmResp
extends PduResponse {
    private static final long serialVersionUID = 1930567419405498513L;
    private String messageId;
    private String finalDate;
    private byte messageState;
    private byte errorCode;

    public QuerySmResp() {
        super(-2147483645, "query_sm_resp");
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String iMessageId) {
        this.messageId = iMessageId;
    }

    public String getFinalDate() {
        return this.finalDate;
    }

    public void setFinalDate(String iFinalDate) {
        this.finalDate = iFinalDate;
    }

    public byte getMessageState() {
        return this.messageState;
    }

    public void setMessageState(byte iMessageState) {
        this.messageState = iMessageState;
    }

    public byte getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(byte iErrorCode) {
        this.errorCode = iErrorCode;
    }

    @Override
    public void readBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.messageId = ByteBufUtil.readNullTerminatedString(buffer);
        this.finalDate = ByteBufUtil.readNullTerminatedString(buffer);
        this.messageState = buffer.readByte();
        this.errorCode = buffer.readByte();
    }

    @Override
    public int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.messageId);
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.finalDate);
        return bodyLength += 2;
    }

    @Override
    public void writeBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        ByteBufUtil.writeNullTerminatedString(buffer, this.messageId);
        ByteBufUtil.writeNullTerminatedString(buffer, this.finalDate);
        buffer.writeByte((int)this.messageState);
        buffer.writeByte((int)this.errorCode);
    }

    @Override
    public void appendBodyToString(StringBuilder buffer) {
        buffer.append("(messageId [");
        buffer.append(this.messageId);
        buffer.append("] finalDate [");
        buffer.append(this.finalDate);
        buffer.append("] messageState [0x");
        buffer.append(HexUtil.toHexString(this.messageState));
        buffer.append("] errorCode [0x");
        buffer.append(HexUtil.toHexString(this.errorCode));
        buffer.append("])");
    }
}

