/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common;

import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicBitSet {
    private final AtomicIntegerArray array;

    public AtomicBitSet(int length) {
        int intLength = length + 31 >>> 5;
        this.array = new AtomicIntegerArray(intLength);
    }

    public void set(long n) {
        int num2;
        int num;
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        while ((num = this.array.get(idx)) != (num2 = num | bit) && !this.array.compareAndSet(idx, num, num2)) {
        }
    }

    public boolean get(long n) {
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        int num = this.array.get(idx);
        return (num & bit) != 0;
    }

    public synchronized int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.array.length(); ++i) {
            sum += Integer.bitCount(this.array.get(i));
        }
        return sum;
    }
}

