/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.queue;

import com.sleepycat.collections.StoredSortedMap;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BdbQueueMap<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final StoredSortedMap<Long, E> queueMap;

    public BdbQueueMap(StoredSortedMap<Long, E> queueMap) {
        this.queueMap = queueMap;
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            E e = this.extract();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E get(Long k) {
        return (E)this.queueMap.get((Object)k);
    }

    E extract() {
        Long firstKey = (Long)this.queueMap.firstKey();
        return (E)(firstKey == null ? null : this.queueMap.remove((Object)firstKey));
    }

    @Override
    public E peek() {
        Long firstKey = (Long)this.queueMap.firstKey();
        return (E)(firstKey == null ? null : this.queueMap.get((Object)firstKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        this.lock.lock();
        try {
            long l;
            Long lastKey = (Long)this.queueMap.lastKey();
            if (lastKey == null) {
                l = 1L;
            } else {
                lastKey = lastKey + 1L;
                l = lastKey;
            }
            lastKey = l;
            this.insert(lastKey, e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Long k, E e) {
        this.lock.lock();
        try {
            this.insert(k, e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            long l;
            Long lastKey = (Long)this.queueMap.lastKey();
            if (lastKey == null) {
                l = 1L;
            } else {
                lastKey = lastKey + 1L;
                l = lastKey;
            }
            lastKey = l;
            this.insert(lastKey, e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Object e) {
        this.lock.lock();
        try {
            boolean bl = this.queueMap.values().remove(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E put(Long k, E e) {
        try {
            this.lock.lockInterruptibly();
            try {
                this.insert(k, e);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return e;
    }

    void insert(Long k, E e) {
        this.queueMap.put((Object)k, e);
        this.notEmpty.signal();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    public boolean offer(Long k, E e, long timeout, TimeUnit unit) {
        return this.offer(k, e);
    }

    @Override
    public E take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Long firstKey;
            while ((firstKey = (Long)this.queueMap.firstKey()) == null) {
                this.notEmpty.await();
            }
            Object object = this.queueMap.remove((Object)firstKey);
            return (E)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Long k, E e) {
        this.lock.lock();
        try {
            if (k != null && e != null) {
                boolean bl = this.queueMap.remove((Object)k, e);
                return bl;
            }
            if (k != null && e == null) {
                boolean bl = this.queueMap.remove((Object)k) != null;
                return bl;
            }
            if (k == null && e != null) {
                boolean bl = this.queueMap.values().remove(e);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.lock();
        try {
            Iterator iterator = this.queueMap.values().iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.queueMap.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        this.lock.lock();
        try {
            int n;
            int max = this.queueMap.size();
            for (n = 0; n < max; ++n) {
                c.add(this.extract());
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        this.lock.lock();
        try {
            int n;
            int max;
            int n2 = max = maxElements > this.queueMap.size() ? this.queueMap.size() : maxElements;
            for (n = 0; n < max; ++n) {
                c.add(this.extract());
            }
            int n3 = n;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }
}

