/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.codec.smpp.Address;
import com.zx.sms.codec.smpp.NotEnoughDataInBufferException;
import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.SmppConstants;
import com.zx.sms.codec.smpp.TerminatingNullByteNotFoundException;
import com.zx.sms.codec.smpp.Tlv;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufUtil {
    private static final Logger logger = LoggerFactory.getLogger(ByteBufUtil.class);

    public static Address readAddress(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        if (buffer.readableBytes() < 3) {
            throw new NotEnoughDataInBufferException("Parsing address", buffer.readableBytes(), 3);
        }
        Address address = new Address();
        address.read(buffer);
        return address;
    }

    public static void writeAddress(ByteBuf buffer, Address value) throws UnrecoverablePduException, RecoverablePduException {
        if (value == null) {
            SmppConstants.EMPTY_ADDRESS.write(buffer);
        } else {
            value.write(buffer);
        }
    }

    public static Tlv readTlv(ByteBuf buffer) throws NotEnoughDataInBufferException {
        if (buffer.readableBytes() < 4) {
            throw new NotEnoughDataInBufferException("Parsing TLV tag and length", buffer.readableBytes(), 4);
        }
        short tag = buffer.readShort();
        int length = buffer.readUnsignedShort();
        if (buffer.readableBytes() < length) {
            throw new NotEnoughDataInBufferException("Parsing TLV value", buffer.readableBytes(), length);
        }
        byte[] value = new byte[length];
        buffer.readBytes(value);
        return new Tlv(tag, value);
    }

    public static void writeTlv(ByteBuf buffer, Tlv tlv) throws NotEnoughDataInBufferException {
        if (tlv == null) {
            return;
        }
        buffer.writeShort((int)tlv.getTag());
        buffer.writeShort((int)tlv.getLength());
        if (tlv.getValue() != null) {
            buffer.writeBytes(tlv.getValue());
        }
    }

    public static void writeNullTerminatedString(ByteBuf buffer, String value) throws UnrecoverablePduException {
        if (value != null) {
            try {
                byte[] bytes = value.getBytes("ISO-8859-1");
                buffer.writeBytes(bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnrecoverablePduException(e.getMessage(), e);
            }
        }
        buffer.writeByte(0);
    }

    public static void writeNullTerminatedStringWithFixedLength(ByteBuf buffer, String value, int length) throws UnrecoverablePduException {
        if (value != null) {
            try {
                byte[] bytes = value.getBytes("ISO-8859-1");
                buffer.writeBytes(bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnrecoverablePduException(e.getMessage(), e);
            }
        }
        buffer.writeByte(0);
    }

    public static String readNullTerminatedString(ByteBuf buffer) throws TerminatingNullByteNotFoundException {
        byte b;
        int zeroPos;
        int maxLength = buffer.readableBytes();
        if (maxLength == 0) {
            return null;
        }
        int offset = buffer.readerIndex();
        for (zeroPos = 0; zeroPos < maxLength && buffer.getByte(zeroPos + offset) != 0; ++zeroPos) {
        }
        if (zeroPos >= maxLength) {
            throw new TerminatingNullByteNotFoundException("Terminating null byte not found after searching [" + maxLength + "] bytes");
        }
        String result = null;
        if (zeroPos > 0) {
            byte[] bytes = new byte[zeroPos];
            buffer.readBytes(bytes);
            try {
                result = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Impossible error", (Throwable)e);
            }
        } else {
            result = "";
        }
        if ((b = buffer.readByte()) != 0) {
            logger.error("Impossible error: last byte read SHOULD have been a null byte, but was [" + b + "]");
        }
        return result;
    }
}

