/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.google.common.base.Preconditions;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.StandardCharsets;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsTextMessage;

public final class CMPPCommonUtil {
    public static final int RandomGateID = CMPPCommonUtil.getRandomGateID();

    public static byte[] ensureLength(byte[] array, int minLength, int padding) {
        Preconditions.checkArgument((minLength >= 0 ? 1 : 0) != 0, (String)"Invalid minLength: %s", (Object[])new Object[]{minLength});
        Preconditions.checkArgument((padding >= 0 ? 1 : 0) != 0, (String)"Invalid padding: %s", (Object[])new Object[]{padding});
        if (array.length == minLength) {
            return array;
        }
        return array.length > minLength ? CMPPCommonUtil.copyOf(array, minLength) : CMPPCommonUtil.copyOf(array, minLength + padding);
    }

    private static byte[] copyOf(byte[] original, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, length));
        return copy;
    }

    public static SmsTextMessage buildTextMessage(String text) {
        return new SmsTextMessage(text);
    }

    public static Charset switchCharset(SmsAlphabet type) {
        switch (type) {
            case ASCII: {
                return StandardCharsets.ISO_8859_1;
            }
            case LATIN1: {
                return StandardCharsets.ISO_8859_1;
            }
            case UCS2: {
                return StandardCharsets.UTF_16BE;
            }
            case RESERVED: {
                return StandardCharsets.GBK;
            }
        }
        return GlobalConstance.defaultTransportCharset;
    }

    private static int getRandomGateID() {
        String propertiesName = "smsgate.id";
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty("smsgate.id") : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("smsgate.id");
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (StringUtils.isBlank(value) || !StringUtils.isNumeric((CharSequence)value)) {
            String vmName = ManagementFactory.getRuntimeMXBean().getName();
            int MaxGateID = 1000000;
            int random = RandomUtils.nextInt((int)1, (int)MaxGateID);
            int prime = 31;
            int result = prime * vmName.hashCode() + random;
            return result > 0 ? result % MaxGateID : -result % MaxGateID;
        }
        return Integer.parseInt(value);
    }
}

