/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.BaseMessage;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManager;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.List;
import org.marre.sms.SmsConcatMessage;
import org.marre.sms.SmsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtil {
    private static final Logger logger = LoggerFactory.getLogger(ChannelUtil.class);

    public static ChannelFuture asyncWriteToEntity(EndpointEntity entity, Object msg) {
        Object connector = entity.getSingletonConnector();
        return ChannelUtil.asyncWriteToEntity(connector, msg, null);
    }

    public static ChannelFuture asyncWriteToEntity(String entity, Object msg) {
        EndpointEntity e = EndpointManager.INS.getEndpointEntity(entity);
        if (e == null) {
            return null;
        }
        Object connector = e.getSingletonConnector();
        return ChannelUtil.asyncWriteToEntity(connector, msg, null);
    }

    public static ChannelFuture asyncWriteToEntity(EndpointEntity entity, Object msg, GenericFutureListener listner) {
        Object connector = entity.getSingletonConnector();
        return ChannelUtil.asyncWriteToEntity(connector, msg, listner);
    }

    public static ChannelFuture asyncWriteToEntity(String entity, Object msg, GenericFutureListener listner) {
        EndpointEntity e = EndpointManager.INS.getEndpointEntity(entity);
        if (e == null) {
            return null;
        }
        Object connector = e.getSingletonConnector();
        return ChannelUtil.asyncWriteToEntity(connector, msg, listner);
    }

    private static ChannelFuture asyncWriteToEntity(EndpointConnector connector, final Object msg, GenericFutureListener listner) {
        if (connector == null || msg == null) {
            return null;
        }
        ChannelFuture promise = connector.asynwrite(msg);
        if (promise == null) {
            return null;
        }
        if (listner == null) {
            promise.addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    if (!future.isSuccess()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("SendMessage ").append(msg.toString()).append(" Failed. ");
                        logger.error(sb.toString(), future.cause());
                    }
                }
            });
        } else {
            promise.addListener(listner);
        }
        return promise;
    }

    public static <T extends BaseMessage> List<T> splitLongSmsMessage(EndpointEntity e, T msg) throws Exception {
        LongSMSMessage lmsg;
        ArrayList<BaseMessage> msgs = new ArrayList<BaseMessage>();
        if (msg instanceof LongSMSMessage && !(lmsg = (LongSMSMessage)((Object)msg)).isReport()) {
            SmsMessage msgcontent = lmsg.getSmsMessage();
            if (msgcontent instanceof SmsConcatMessage) {
                ((SmsConcatMessage)msgcontent).setSeqNoKey(lmsg.getSrcIdAndDestId());
            }
            List<LongMessageFrame> frameList = LongMessageFrameHolder.INS.splitmsgcontent(msgcontent);
            UniqueLongMsgId uniqueId = null;
            for (LongMessageFrame frame : frameList) {
                LongSMSMessage t = (LongSMSMessage)lmsg.generateMessage(frame);
                if (uniqueId == null) {
                    uniqueId = new UniqueLongMsgId(e, t);
                    t.setUniqueLongMsgId(uniqueId);
                } else {
                    frame.setTimestamp(((BaseMessage)((Object)t)).getTimestamp());
                    frame.setSequence(((BaseMessage)((Object)t)).getSequenceNo());
                    t.setUniqueLongMsgId(new UniqueLongMsgId(uniqueId, frame));
                }
                msgs.add((BaseMessage)((Object)t));
            }
            return msgs;
        }
        msgs.add(msg);
        return msgs;
    }

    public static <T extends BaseMessage> List<Promise<T>> syncWriteLongMsgToEntity(EndpointEntity e, BaseMessage msg) throws Exception {
        Object connector = e.getSingletonConnector();
        if (connector == null) {
            return null;
        }
        if (msg instanceof LongSMSMessage && !((LongSMSMessage)((Object)msg)).isReport()) {
            LongSMSMessage lmsg = (LongSMSMessage)((Object)msg);
            List<BaseMessage> msgs = ChannelUtil.splitLongSmsMessage(e, msg);
            return connector.synwrite(msgs);
        }
        Promise<BaseMessage> promise = connector.synwrite((BaseMessage)msg);
        if (promise == null) {
            return null;
        }
        ArrayList<Promise<T>> arrPromise = new ArrayList<Promise<T>>();
        arrPromise.add(promise);
        return arrPromise;
    }

    public static <T extends BaseMessage> List<Promise<T>> syncWriteLongMsgToEntity(String entity, BaseMessage msg) throws Exception {
        EndpointEntity e = EndpointManager.INS.getEndpointEntity(entity);
        if (e == null) {
            logger.warn("EndpointEntity {} is null", (Object)entity);
            return null;
        }
        return ChannelUtil.syncWriteLongMsgToEntity(e, msg);
    }

    public static <T extends BaseMessage> Promise<T> syncWriteBinaryMsgToEntity(String entity, BaseMessage msg) throws Exception {
        EndpointEntity e = EndpointManager.INS.getEndpointEntity(entity);
        Object connector = e.getSingletonConnector();
        Promise<BaseMessage> promise = connector.synwrite((BaseMessage)msg);
        if (promise == null) {
            return null;
        }
        return promise;
    }
}

