/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.SequenceNumber;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DefaultSequenceNumberUtil {
    private static final String[] datePattern = new String[]{"yyyyMMddHHmmss"};
    private static final AtomicInteger sequenceId = new AtomicInteger(RandomUtils.nextInt());

    public static byte[] sequenceN2Bytes(SequenceNumber sn) {
        byte[] bytes = new byte[12];
        long t = Long.parseLong(sn.getTimeString());
        ByteBuffer.wrap(bytes).putInt((int)sn.getNodeIds()).putInt((int)t).putInt(sn.getSequenceId());
        return bytes;
    }

    public static SequenceNumber bytes2SequenceN(byte[] bytes) {
        long nodeIds = (long)ByteBuffer.wrap(Arrays.copyOfRange(bytes, 0, 4)).getInt() & 0xFFFFFFFFL;
        String monthDayTime = StringUtils.leftPad((String)String.valueOf(ByteBuffer.wrap(Arrays.copyOfRange(bytes, 4, 8)).getInt()), (int)10, (char)'0');
        long timestamp = DefaultSequenceNumberUtil.getTimestampFromMonthDayTime(monthDayTime);
        int sequenceId = ByteBuffer.wrap(Arrays.copyOfRange(bytes, 8, 12)).getInt();
        SequenceNumber sn = new SequenceNumber(timestamp, nodeIds, sequenceId);
        return sn;
    }

    public static long getTimestampFromMonthDayTime(String monthDayTime) {
        Date d;
        String year = DateFormatUtils.format((long)CachedMillisecondClock.INS.now(), (String)"yyyy");
        String t = year + monthDayTime;
        try {
            d = DateUtils.parseDate((String)t, (String[])datePattern);
            if (d.getTime() - CachedMillisecondClock.INS.now() > 17280000000L) {
                d = DateUtils.addYears((Date)d, (int)-1);
            }
        }
        catch (ParseException e) {
            d = new Date();
            e.printStackTrace();
        }
        return d.getTime();
    }

    public static int getSequenceNo() {
        return sequenceId.incrementAndGet() & Integer.MAX_VALUE;
    }
}

