/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class IPRange {
    private InetAddress inetAddress;
    private String mask = "";

    public IPRange(String ip) throws UnknownHostException {
        int idx = ip.indexOf(47);
        String address = null;
        String mask = null;
        if (idx > 0 && idx < ip.length() - 1) {
            address = ip.substring(0, idx);
            mask = ip.substring(idx + 1);
        } else if (idx < 0) {
            address = ip;
        } else {
            throw new IllegalArgumentException("not an valid ip format!");
        }
        this.inetAddress = InetAddress.getByName(address);
        if (StringUtils.isNotBlank(mask)) {
            this.mask = mask;
            this.inetAddress = this.gennetworkPart(this.inetAddress, Byte.valueOf(mask));
        }
    }

    private InetAddress gennetworkPart(InetAddress src, byte bmask) throws UnknownHostException {
        byte[] addr = src.getAddress();
        int pos = bmask / 8;
        int bitp = bmask % 8;
        if (pos > addr.length) {
            throw new IllegalArgumentException("not an valid mask value :" + this.mask);
        }
        byte[] result = new byte[addr.length];
        for (int i = 0; i < pos; ++i) {
            result[i] = addr[i];
        }
        if (bitp > 0) {
            byte tmpmask = (byte)(-1 << 8 - bitp);
            result[pos] = (byte)(addr[pos] & tmpmask);
        }
        return InetAddress.getByAddress(result);
    }

    public boolean isInRange(String src) {
        try {
            return this.isInRange(InetAddress.getByName(src));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInRange(InetAddress src) {
        try {
            if (StringUtils.isBlank((CharSequence)this.mask)) {
                return this.inetAddress.equals(src);
            }
            return this.inetAddress.equals(this.gennetworkPart(src, Byte.valueOf(this.mask)));
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IPRange [inetAddress=");
        builder.append(this.inetAddress);
        builder.append(", mask=");
        builder.append(this.mask);
        builder.append("]");
        return builder.toString();
    }
}

