/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.DefaultMsgIdUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MsgId
implements Serializable {
    private static final long serialVersionUID = 945466149547731811L;
    private static final AtomicInteger _sequenceId = new AtomicInteger(RandomUtils.nextInt());
    private int month;
    private int day;
    private int hour;
    private int minutes;
    private int seconds;
    private int gateId;
    private int sequenceId;

    public MsgId() {
        this(CachedMillisecondClock.INS.now());
    }

    public MsgId(int gateId) {
        this(CachedMillisecondClock.INS.now(), gateId, _sequenceId.incrementAndGet());
    }

    public MsgId(long timeMillis) {
        this(timeMillis, CMPPCommonUtil.RandomGateID, _sequenceId.incrementAndGet());
    }

    public MsgId(String msgIds) {
        this.setMonth(Integer.parseInt(msgIds.substring(0, 2)));
        this.setDay(Integer.parseInt(msgIds.substring(2, 4)));
        this.setHour(Integer.parseInt(msgIds.substring(4, 6)));
        this.setMinutes(Integer.parseInt(msgIds.substring(6, 8)));
        this.setSeconds(Integer.parseInt(msgIds.substring(8, 10)));
        this.setGateId(Integer.parseInt(msgIds.substring(10, 17)));
        this.setSequenceId(Integer.parseInt(msgIds.substring(17, 22)));
    }

    public MsgId(long timeMillis, int gateId, int sequenceId) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        this.setMonth(cal.get(2) + 1);
        this.setDay(cal.get(5));
        this.setHour(cal.get(11));
        this.setMinutes(cal.get(12));
        this.setSeconds(cal.get(13));
        this.setGateId(gateId);
        this.setSequenceId(sequenceId);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public int getGateId() {
        return this.gateId & 0x3FFFFF;
    }

    public void setGateId(int gateId) {
        Validate.isTrue((gateId <= 0x3FFFFF && gateId >= 0 ? 1 : 0) != 0, (String)"gateId must be non-negative  and  less than 4194304 . now is %s", (long)gateId);
        this.gateId = gateId & 0x3FFFFF;
    }

    public int getSequenceId() {
        return this.sequenceId & 0xFFFF;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId & 0xFFFF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad((String)String.valueOf(this.month), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.day), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.hour), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.minutes), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.seconds), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.gateId), (int)7, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.sequenceId), (int)5, (char)'0'));
        return sb.toString();
    }

    public String toHexString(boolean toLowerCase) {
        return Hex.encodeHexString((byte[])DefaultMsgIdUtil.msgId2Bytes(this), (boolean)toLowerCase);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.gateId;
        result = 31 * result + this.hour;
        result = 31 * result + this.minutes;
        result = 31 * result + this.month;
        result = 31 * result + this.seconds;
        result = 31 * result + this.sequenceId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MsgId other = (MsgId)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.gateId != other.gateId) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        if (this.minutes != other.minutes) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.seconds != other.seconds) {
            return false;
        }
        return this.sequenceId == other.sequenceId;
    }
}

