/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.MsgId;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SequenceNumber
implements Serializable {
    private static final long serialVersionUID = 650229326111998772L;
    private static final String[] datePattern = new String[]{"yyyyMMddHHmmss"};
    private long nodeIds;
    private int sequenceId;
    private long timestamp;

    public SequenceNumber() {
        this(CachedMillisecondClock.INS.now());
    }

    public SequenceNumber(long nodeIds, long timeMillis) {
        this(timeMillis, nodeIds, DefaultSequenceNumberUtil.getSequenceNo());
    }

    public SequenceNumber(long timeMillis) {
        this(timeMillis, 1010L, DefaultSequenceNumberUtil.getSequenceNo());
    }

    public SequenceNumber(String str_sequenceId) {
        this.setNodeIds(Long.parseLong(str_sequenceId.substring(0, 10)));
        this.setTimestamp(DefaultSequenceNumberUtil.getTimestampFromMonthDayTime(str_sequenceId.substring(10, 20)));
        this.setSequenceId(Integer.parseInt(str_sequenceId.substring(20, 30)));
    }

    public SequenceNumber(MsgId msgIds) {
        String strmsgid = msgIds.toString();
        this.setNodeIds(msgIds.getGateId());
        this.setTimestamp(DefaultSequenceNumberUtil.getTimestampFromMonthDayTime(strmsgid.substring(0, 10)));
        this.setSequenceId(msgIds.getSequenceId());
    }

    public SequenceNumber(long timeMillis, long nodeIds, int sequenceId) {
        this.setNodeIds(nodeIds);
        this.setSequenceId(sequenceId);
        this.setTimestamp(timeMillis);
    }

    public long getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long nodeIds) {
        this.nodeIds = nodeIds;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getTimeString() {
        return DateFormatUtils.format((long)this.timestamp, (String)"MMddHHmmss");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad((String)String.valueOf(this.nodeIds), (int)10, (char)'0')).append(this.getTimeString()).append(StringUtils.leftPad((String)String.valueOf(this.sequenceId), (int)10, (char)'0'));
        return sb.toString();
    }
}

