/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.connect.manager.AbstractEndpointConnector;
import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EventLoopGroupFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientEndpointConnector
extends AbstractEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClientEndpointConnector.class);
    private Bootstrap bootstrap = new Bootstrap();

    public AbstractClientEndpointConnector(EndpointEntity endpoint) {
        super(endpoint);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(EventLoopGroupFactory.INS.getWorker())).channel(EventLoopGroupFactory.selectChannelClass())).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)16384)).option(ChannelOption.SO_SNDBUF, (Object)8192)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler(this.initPipeLine());
    }

    @Override
    public ChannelFuture open() throws Exception {
        String host = this.getEndpointEntity().getHost();
        String localhost = this.getEndpointEntity().getLocalhost();
        Integer localport = this.getEndpointEntity().getLocalport();
        InetSocketAddress localaddr = null;
        if (StringUtils.isNotBlank((CharSequence)localhost) && localport != null) {
            localaddr = SocketUtils.socketAddress((String)localhost, (int)localport);
        }
        if (StringUtils.isBlank((CharSequence)host)) {
            logger.error("remote host is blank");
            return null;
        }
        return this.doConnect(host.split(","), 0, this.getEndpointEntity().getPort(), localaddr);
    }

    private ChannelFuture doConnect(final String[] hosts, final int idx, final int port, final SocketAddress localaddress) {
        if (idx >= hosts.length) {
            logger.error("hosts.length is {} ,but idx is {}.", (Object)hosts.length, (Object)idx);
            return null;
        }
        ChannelFuture future = this.bootstrap.connect((SocketAddress)SocketUtils.socketAddress((String)hosts[idx], (int)port), localaddress);
        future.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    if (idx + 1 < hosts.length) {
                        logger.info("retry connect to next host {}:{}", (Object)hosts[idx + 1], (Object)port);
                        AbstractClientEndpointConnector.this.doConnect(hosts, idx + 1, port, localaddress);
                    } else {
                        logger.error("Connect to {}:{} failed. cause by {}.", new Object[]{AbstractClientEndpointConnector.this.getEndpointEntity().getHost(), port, f.cause().getMessage()});
                    }
                }
            }
        });
        return future;
    }

    @Override
    protected SslContext createSslCtx() {
        try {
            if (this.getEndpointEntity().isUseSSL()) {
                return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    protected void initSslCtx(Channel ch, EndpointEntity entity) {
        ChannelPipeline pipeline = ch.pipeline();
        if (entity instanceof ClientEndpoint) {
            logger.info("EndpointEntity {} Use SSL.", (Object)entity);
            pipeline.addLast(new ChannelHandler[]{this.getSslCtx().newHandler(ch.alloc(), entity.getHost(), entity.getPort().intValue())});
        }
    }
}

