/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.BaseMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageMarkerReadHandler;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.storedMap.BDBStoredMapFactoryImpl;
import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.cmpp.CMPPServerEndpointEntity;
import com.zx.sms.handler.MessageLogHandler;
import com.zx.sms.handler.api.AbstractBusinessHandler;
import com.zx.sms.handler.api.BusinessHandlerInterface;
import com.zx.sms.session.AbstractSessionStateManager;
import com.zx.sms.session.cmpp.SessionState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.traffic.WindowSizeChannelTrafficShapingHandler;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpointConnector
implements EndpointConnector<EndpointEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEndpointConnector.class);
    private SslContext sslCtx = null;
    private EndpointEntity endpoint;
    private CircularList channels = new CircularList();

    public AbstractEndpointConnector(EndpointEntity endpoint) {
        this.endpoint = endpoint;
        this.sslCtx = this.createSslCtx();
    }

    protected abstract SslContext createSslCtx();

    @Override
    public EndpointEntity getEndpointEntity() {
        return this.endpoint;
    }

    @Override
    public void close(Channel channel) throws Exception {
        if (channel.isOpen()) {
            channel.close();
        }
        this.removeChannel(channel);
    }

    @Override
    public void close() throws Exception {
        Channel[] chs = this.channels.getall();
        if (chs == null || chs.length == 0) {
            return;
        }
        for (Channel ch : chs) {
            this.close(ch);
        }
    }

    @Override
    public Channel fetch() {
        Channel ch = this.channels.fetch();
        if (ch != null && ch.isActive() && ch.attr(GlobalConstance.attributeKey).get() == SessionState.Connect) {
            return ch;
        }
        return null;
    }

    public SslContext getSslCtx() {
        return this.sslCtx;
    }

    @Override
    public int getConnectionNum() {
        return this.getChannels().size();
    }

    private CircularList getChannels() {
        return this.channels;
    }

    protected abstract AbstractSessionStateManager createSessionManager(EndpointEntity var1, ConcurrentMap var2, boolean var3);

    protected abstract void doBindHandler(ChannelPipeline var1, EndpointEntity var2);

    protected abstract void doinitPipeLine(ChannelPipeline var1);

    protected void addProxyHandler(Channel ch, URI proxy) throws NotSupportedException {
        int idx;
        if (proxy == null) {
            return;
        }
        String scheme = proxy.getScheme();
        String userinfo = proxy.getUserInfo();
        String host = proxy.getHost();
        int port = proxy.getPort();
        String username = null;
        String pass = null;
        if (StringUtils.isNotBlank((CharSequence)userinfo) && (idx = userinfo.indexOf(":")) > 0) {
            username = userinfo.substring(0, idx);
            pass = userinfo.substring(idx + 1);
        }
        ChannelPipeline pipeline = ch.pipeline();
        if ("HTTP".equalsIgnoreCase(scheme)) {
            if (username == null) {
                pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(host, port))});
            } else {
                pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(host, port), username, pass)});
            }
        } else if ("SOCKS5".equalsIgnoreCase(scheme)) {
            if (username == null) {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(host, port))});
            } else {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(host, port), username, pass)});
            }
        } else if ("SOCKS4".equalsIgnoreCase(scheme)) {
            if (username == null) {
                pipeline.addLast(new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)new InetSocketAddress(host, port))});
            } else {
                pipeline.addLast(new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)new InetSocketAddress(host, port), username)});
            }
        } else {
            throw new NotSupportedException("not support proxy protocol " + scheme);
        }
    }

    protected ChannelInitializer<?> initPipeLine() {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                EndpointEntity entity = AbstractEndpointConnector.this.getEndpointEntity();
                if (entity instanceof ClientEndpoint && StringUtils.isNotBlank((CharSequence)entity.getProxy())) {
                    String uriString = entity.getProxy();
                    try {
                        URI uri = URI.create(uriString);
                        AbstractEndpointConnector.this.addProxyHandler(ch, uri);
                    }
                    catch (Exception ex) {
                        logger.error("parse Proxy URI {} failed.", (Object)uriString, (Object)ex);
                    }
                }
                if (entity.isUseSSL() && AbstractEndpointConnector.this.getSslCtx() != null) {
                    AbstractEndpointConnector.this.initSslCtx(ch, entity);
                }
                AbstractEndpointConnector.this.doinitPipeLine(pipeline);
            }
        };
    }

    @Override
    public synchronized boolean addChannel(Channel ch) {
        int nowConnCnt = this.getConnectionNum();
        EndpointEntity endpoint = this.getEndpointEntity();
        if (endpoint.getMaxChannels() == 0 || endpoint.getMaxChannels() > nowConnCnt) {
            AbstractSessionStateManager sessionManager;
            Map storedMap = null;
            storedMap = endpoint.isReSendFailMsg() ? BDBStoredMapFactoryImpl.INS.buildMap(endpoint.getId(), "Session_" + endpoint.getId()) : new ConcurrentHashMap();
            logger.info("Channel added To Endpoint {} .totalCnt:{} ,remoteAddress: {}", new Object[]{endpoint, nowConnCnt + 1, ch.remoteAddress()});
            if (nowConnCnt == 0 && endpoint.isReSendFailMsg()) {
                sessionManager = this.createSessionManager(endpoint, (ConcurrentMap)storedMap, true);
                ch.pipeline().addAfter("codecName", "sessionStateManager", (ChannelHandler)sessionManager);
            } else {
                sessionManager = this.createSessionManager(endpoint, (ConcurrentMap)storedMap, false);
                ch.pipeline().addAfter("codecName", "sessionStateManager", (ChannelHandler)sessionManager);
            }
            ch.pipeline().addAfter("codecName", "ChannelTrafficAfter", (ChannelHandler)new WindowSizeChannelTrafficShapingHandler(endpoint, 100L));
            ch.pipeline().addAfter("codecName", "msgLog", (ChannelHandler)new MessageLogHandler(endpoint));
            LongMessageMarkerReadHandler h_readMarker = new LongMessageMarkerReadHandler(endpoint);
            ch.pipeline().addAfter("codecName", h_readMarker.name(), (ChannelHandler)h_readMarker);
            this.bindHandler(ch.pipeline(), endpoint);
            ch.attr(GlobalConstance.attributeKey).set((Object)SessionState.Connect);
            ch.attr(GlobalConstance.entityPointKey).set((Object)endpoint);
            ch.attr(GlobalConstance.sessionKey).set((Object)sessionManager);
            this.getChannels().add(ch);
            return true;
        }
        logger.warn("allowed max channel count: {} ,deny to login.{}", (Object)endpoint.getMaxChannels(), (Object)endpoint);
        return false;
    }

    @Override
    public void removeChannel(Channel ch) {
        if (this.getChannels().remove(ch)) {
            ch.attr(GlobalConstance.attributeKey).set((Object)SessionState.DisConnect);
            ch.attr(GlobalConstance.sessionKey).set(null);
            ch.attr(GlobalConstance.entityPointKey).set(null);
        }
    }

    protected void bindHandler(ChannelPipeline pipe, EndpointEntity entity) {
        if (entity instanceof CMPPServerEndpointEntity) {
            return;
        }
        pipe.addFirst("socketLog", (ChannelHandler)new LoggingHandler(String.format("entity.%s", entity.getId()), LogLevel.TRACE));
        this.doBindHandler(pipe, entity);
        List<BusinessHandlerInterface> handlers = entity.getBusinessHandlerSet();
        if (handlers != null && handlers.size() > 0) {
            for (BusinessHandlerInterface handler : handlers) {
                if (handler instanceof AbstractBusinessHandler) {
                    AbstractBusinessHandler buziHandler = (AbstractBusinessHandler)handler;
                    buziHandler.setEndpointEntity(entity);
                    if (buziHandler.isSharable()) {
                        pipe.addLast(buziHandler.name(), (ChannelHandler)buziHandler);
                        continue;
                    }
                    AbstractBusinessHandler cloned = null;
                    try {
                        cloned = buziHandler.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        logger.error("handlers is not shareable and not implements Cloneable", (Throwable)e);
                    }
                    if (cloned == null) continue;
                    cloned.setEndpointEntity(entity);
                    pipe.addLast(buziHandler.name(), (ChannelHandler)cloned);
                    logger.info("handlers is not shareable . clone it success. {}", (Object)cloned);
                    continue;
                }
                handler.setEndpointEntity(entity);
                pipe.addLast(handler.name(), (ChannelHandler)handler);
                logger.info("add share handlers . {}", (Object)handler);
            }
        }
        pipe.addLast("BlackHole", (ChannelHandler)GlobalConstance.blackhole);
    }

    protected abstract void initSslCtx(Channel var1, EndpointEntity var2);

    @Override
    public Channel[] getallChannel() {
        return this.channels.getall();
    }

    @Override
    public ChannelFuture asynwriteUncheck(Object msg) {
        Channel ch = this.fetch();
        if (ch == null) {
            return null;
        }
        ChannelFuture future = ch.writeAndFlush(msg);
        return future;
    }

    @Override
    public ChannelFuture asynwrite(Object msg) {
        Channel ch = this.fetchOneWritable();
        if (ch == null) {
            return null;
        }
        ChannelFuture future = ch.writeAndFlush(msg);
        return future;
    }

    @Override
    public <T extends BaseMessage> Promise<T> synwriteUncheck(T message) {
        return this.synwrite(message, false);
    }

    @Override
    public <T extends BaseMessage> List<Promise<T>> synwriteUncheck(List<T> msgs) {
        return this.synwrite(msgs, false);
    }

    @Override
    public <T extends BaseMessage> List<Promise<T>> synwrite(List<T> msgs) {
        return this.synwrite(msgs, true);
    }

    @Override
    public <T extends BaseMessage> Promise<T> synwrite(T message) {
        return this.synwrite(message, true);
    }

    private <T extends BaseMessage> List<Promise<T>> synwrite(List<T> msgs, boolean checkWritable) {
        Channel ch;
        Channel channel = ch = checkWritable ? this.fetchOneWritable() : this.fetch();
        if (ch == null) {
            return null;
        }
        AbstractSessionStateManager session = (AbstractSessionStateManager)((Object)ch.attr(GlobalConstance.sessionKey).get());
        if (session == null) {
            return null;
        }
        ArrayList<Promise<T>> arrPromise = new ArrayList<Promise<T>>();
        for (BaseMessage msg : msgs) {
            arrPromise.add(session.writeMessagesync(msg));
        }
        return arrPromise;
    }

    private <T extends BaseMessage> Promise<T> synwrite(T message, boolean checkWritable) {
        Channel ch;
        Channel channel = ch = checkWritable ? this.fetchOneWritable() : this.fetch();
        if (ch == null) {
            return null;
        }
        AbstractSessionStateManager session = (AbstractSessionStateManager)((Object)ch.attr(GlobalConstance.sessionKey).get());
        if (session == null) {
            return null;
        }
        return session.writeMessagesync(message);
    }

    private Channel fetchOneWritable() {
        Channel ch = this.fetch();
        if (ch == null) {
            return null;
        }
        if (ch.isActive() && ch.isWritable()) {
            return ch;
        }
        return null;
    }

    private class CircularList {
        private List<Channel> collection = Collections.synchronizedList(new ArrayList());
        private AtomicInteger indexSeq = new AtomicInteger();

        private CircularList() {
        }

        public Channel[] getall() {
            return this.collection.toArray(new Channel[this.collection.size()]);
        }

        public int size() {
            return this.collection.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Channel fetch() {
            block7: {
                Channel ret;
                int size = this.collection.size();
                if (size == 0) {
                    return null;
                }
                if (size == 1) {
                    return this.collection.get(0);
                }
                int idx = this.indexSeq.getAndIncrement();
                if (idx >= this.collection.size()) break block7;
                Channel channel = ret = this.collection.get(idx);
                return channel;
            }
            try {
                Channel ret = this.collection.get(0);
                this.indexSeq.set(0);
                Channel channel = ret;
                return channel;
            }
            catch (IndexOutOfBoundsException ex) {
                Channel channel = this.collection.isEmpty() ? null : this.collection.get(0);
                return channel;
            }
        }

        public boolean add(Channel ele) {
            boolean r = false;
            r = this.collection.add(ele);
            return r;
        }

        public boolean remove(Channel ele) {
            boolean r = false;
            r = this.collection.remove(ele);
            return r;
        }
    }
}

