/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.connect.manager.AbstractEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EventLoopGroupFactory;
import com.zx.sms.connect.manager.ServerEndpoint;
import com.zx.sms.session.AbstractSessionStateManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerEndpointConnector
extends AbstractEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerEndpointConnector.class);
    private ServerBootstrap bootstrap = new ServerBootstrap();
    private Channel acceptorChannel = null;
    private final DefaultChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public AbstractServerEndpointConnector(EndpointEntity e) {
        super(e);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(EventLoopGroupFactory.INS.getBoss(), EventLoopGroupFactory.INS.getWorker()).channel(EventLoopGroupFactory.selectServerChannelClass())).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_RCVBUF, (Object)16384).childOption(ChannelOption.SO_SNDBUF, (Object)8192).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler(this.initPipeLine());
    }

    @Override
    public ChannelFuture open() throws Exception {
        logger.debug("Open Entity {}", (Object)this.getEndpointEntity());
        ChannelFuture future = null;
        future = this.getEndpointEntity().getHost() == null ? this.bootstrap.bind(this.getEndpointEntity().getPort().intValue()).sync() : this.bootstrap.bind(this.getEndpointEntity().getHost(), this.getEndpointEntity().getPort().intValue()).sync();
        this.acceptorChannel = future.channel();
        return future;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.acceptorChannel != null) {
            this.acceptorChannel.close();
        }
        this.acceptorChannel = null;
        this.allChannels.close();
    }

    @Override
    protected SslContext createSslCtx() {
        try {
            if (this.getEndpointEntity().isUseSSL()) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    protected void initSslCtx(Channel ch, EndpointEntity entity) {
        ChannelPipeline pipeline = ch.pipeline();
        if (entity instanceof ServerEndpoint) {
            logger.info("EndpointEntity {} Use SSL.", (Object)entity);
            pipeline.addLast(new ChannelHandler[]{this.getSslCtx().newHandler(ch.alloc())});
        }
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity entity) {
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                AbstractServerEndpointConnector.this.allChannels.add(ctx.channel());
                ctx.fireChannelActive();
            }
        }});
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return null;
    }
}

