/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.handler.api.BusinessHandlerInterface;
import java.io.Serializable;
import java.util.List;

public abstract class EndpointEntity
implements Serializable {
    static final long serialVersionUID = 42L;
    private String Id;
    private String Desc;
    private ChannelType channelType = ChannelType.DUPLEX;
    private String host;
    private Integer port;
    private String localhost;
    private Integer localport;
    private short maxChannels;
    private boolean valid = true;
    private SupportLongMessage supportLongmsg = SupportLongMessage.BOTH;
    private List<BusinessHandlerInterface> businessHandlerSet;
    private boolean isReSendFailMsg = false;
    private short maxRetryCnt = (short)3;
    private short retryWaitTimeSec = (short)60;
    private short idleTimeSec = (short)30;
    boolean closeWhenRetryFailed = true;
    private int readLimit = 0;
    private int writeLimit = 0;
    private boolean useSSL = false;
    private String proxy;
    private volatile EndpointConnector connector;
    private int window = 16;
    private List<String> allowedAddr;
    private boolean isRecvLongMsgOnMultiLink = false;

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public int getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(int readLimit) {
        this.readLimit = readLimit;
    }

    public int getWriteLimit() {
        return this.writeLimit;
    }

    public void setWriteLimit(int writeLimit) {
        this.writeLimit = writeLimit;
    }

    public short getIdleTimeSec() {
        return this.idleTimeSec;
    }

    public void setIdleTimeSec(short idleTimeSec) {
        this.idleTimeSec = idleTimeSec;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getId() {
        return this.Id;
    }

    public void setId(String id) {
        this.Id = id;
    }

    public String getDesc() {
        return this.Desc;
    }

    public void setDesc(String desc) {
        this.Desc = desc;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    public Integer getLocalport() {
        return this.localport;
    }

    public void setLocalport(Integer localport) {
        this.localport = localport;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public short getMaxChannels() {
        return this.maxChannels;
    }

    public void setMaxChannels(short maxChannels) {
        this.maxChannels = maxChannels;
    }

    public List<BusinessHandlerInterface> getBusinessHandlerSet() {
        return this.businessHandlerSet;
    }

    public void setBusinessHandlerSet(List<BusinessHandlerInterface> businessHandlerSet) {
        this.businessHandlerSet = businessHandlerSet;
    }

    public boolean isReSendFailMsg() {
        return this.isReSendFailMsg;
    }

    public void setReSendFailMsg(boolean isReSendFailMsg) {
        this.isReSendFailMsg = isReSendFailMsg;
    }

    public short getMaxRetryCnt() {
        return this.maxRetryCnt;
    }

    public void setMaxRetryCnt(short maxRetryCnt) {
        this.maxRetryCnt = maxRetryCnt < 0 ? (short)0 : maxRetryCnt;
    }

    public short getRetryWaitTimeSec() {
        return this.retryWaitTimeSec;
    }

    public void setRetryWaitTimeSec(short retryWaitTimeSec) {
        this.retryWaitTimeSec = (short)(retryWaitTimeSec <= 0 ? 60 : (int)retryWaitTimeSec);
    }

    public SupportLongMessage getSupportLongmsg() {
        return this.supportLongmsg;
    }

    public void setSupportLongmsg(SupportLongMessage supportLongmsg) {
        this.supportLongmsg = supportLongmsg;
    }

    public boolean isCloseWhenRetryFailed() {
        return this.closeWhenRetryFailed;
    }

    public void setCloseWhenRetryFailed(boolean closeWhenRetryFailed) {
        this.closeWhenRetryFailed = closeWhenRetryFailed;
    }

    public List<String> getAllowedAddr() {
        return this.allowedAddr;
    }

    public void setAllowedAddr(List<String> allowedAddr) {
        this.allowedAddr = allowedAddr;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        this.window = window;
    }

    public boolean isRecvLongMsgOnMultiLink() {
        return this.isRecvLongMsgOnMultiLink;
    }

    public void setRecvLongMsgOnMultiLink(boolean isRecvLongMsgOnMultiLink) {
        this.isRecvLongMsgOnMultiLink = isRecvLongMsgOnMultiLink;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.Id == null ? 0 : this.Id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointEntity other = (EndpointEntity)obj;
        return !(this.Id == null ? other.Id != null : !this.Id.equals(other.Id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EndpointConnector<EndpointEntity>> T getSingletonConnector() {
        if (this.connector != null) {
            return (T)this.connector;
        }
        EndpointEntity endpointEntity = this;
        synchronized (endpointEntity) {
            if (this.connector != null) {
                return (T)this.connector;
            }
            this.connector = this.buildConnector();
            return (T)this.connector;
        }
    }

    protected abstract <T extends EndpointConnector<EndpointEntity>> T buildConnector();

    public String toString() {
        return "EndpointEntity [Id=" + this.Id + ", Desc=" + this.Desc + ", channelType=" + (Object)((Object)this.channelType) + ", host=" + this.host + ", port=" + this.port + ", maxChannels=" + this.maxChannels + ", valid=" + this.valid + ", businessHandlerSet=" + this.businessHandlerSet + "]";
    }

    public static enum ChannelType {
        UP,
        DOWN,
        DUPLEX;

    }

    public static enum SupportLongMessage {
        NONE,
        SEND,
        RECV,
        BOTH;

    }
}

