/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManagerInterface;
import com.zx.sms.connect.manager.EventLoopGroupFactory;
import com.zx.sms.connect.manager.ExitUnlimitCirclePolicy;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EndpointManager implements EndpointManagerInterface
{
    INS;

    private static final Logger logger;
    private Set<EndpointEntity> endpoints = Collections.synchronizedSet(new HashSet());
    private ConcurrentHashMap<String, EndpointEntity> idMap = new ConcurrentHashMap();
    private volatile boolean started = false;

    @Override
    public synchronized void openEndpoint(EndpointEntity entity) {
        if (!entity.isValid()) {
            return;
        }
        EndpointEntity old = this.idMap.get(entity.getId());
        if (old == null) {
            this.addEndpointEntity(entity);
            old = this.idMap.get(entity.getId());
        }
        Object conn = old.getSingletonConnector();
        try {
            conn.open();
        }
        catch (Exception e) {
            logger.error("Open Endpoint Error. {}", (Object)old, (Object)e);
        }
    }

    @Override
    public synchronized void close(EndpointEntity entity) {
        Object conn = entity.getSingletonConnector();
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            logger.error("close Error", (Throwable)e);
        }
    }

    @Override
    public EndpointEntity getEndpointEntity(String id) {
        return this.idMap.get(id);
    }

    @Override
    public void openAll() throws Exception {
        for (EndpointEntity e : this.endpoints) {
            this.openEndpoint(e);
        }
    }

    @Override
    public synchronized void addEndpointEntity(EndpointEntity entity) {
        this.endpoints.add(entity);
        this.idMap.put(entity.getId(), entity);
    }

    @Override
    public void addAllEndpointEntity(List<EndpointEntity> entities) {
        if (entities == null || entities.size() == 0) {
            return;
        }
        for (EndpointEntity entity : entities) {
            if (!entity.isValid()) continue;
            this.addEndpointEntity(entity);
        }
    }

    @Override
    public Set<EndpointEntity> allEndPointEntity() {
        return this.endpoints;
    }

    @Override
    public synchronized void remove(String id) {
        EndpointEntity entity = this.idMap.remove(id);
        if (entity != null) {
            this.endpoints.remove(entity);
            this.close(entity);
        }
    }

    @Override
    public void close() {
        this.stopConnectionCheckTask();
        for (EndpointEntity en : this.endpoints) {
            this.close(en);
        }
    }

    @Override
    public void stopConnectionCheckTask() {
        this.started = false;
    }

    @Override
    public void startConnectionCheckTask() {
        if (this.started) {
            return;
        }
        this.started = true;
        EventLoopGroupFactory.INS.submitUnlimitCircleTask(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (Map.Entry entry : EndpointManager.this.idMap.entrySet()) {
                    EndpointEntity entity = (EndpointEntity)entry.getValue();
                    if (!(entity instanceof ClientEndpoint)) continue;
                    Object conn = entity.getSingletonConnector();
                    short max = entity.getMaxChannels();
                    int actual = conn.getConnectionNum();
                    if (actual >= max) continue;
                    logger.debug("open connection {}", (Object)entity);
                    conn.open();
                }
                return EndpointManager.this.started;
            }
        }, new ExitUnlimitCirclePolicy<Boolean>(){

            @Override
            public boolean notOver(Future<Boolean> future) {
                return EndpointManager.this.started;
            }
        }, 1000L);
    }

    @Override
    public EndpointConnector getEndpointConnector(EndpointEntity entity) {
        return entity.getSingletonConnector();
    }

    @Override
    public EndpointConnector getEndpointConnector(String id) {
        EndpointEntity entity = this.getEndpointEntity(id);
        return entity == null ? null : (EndpointConnector)entity.getSingletonConnector();
    }

    @Override
    public void removeAll() {
        Iterator<Map.Entry<String, EndpointEntity>> itor = this.idMap.entrySet().iterator();
        ArrayList<String> ids = new ArrayList<String>();
        while (itor.hasNext()) {
            ids.add(itor.next().getKey());
        }
        for (String id : ids) {
            this.remove(id);
        }
    }

    static {
        logger = LoggerFactory.getLogger(EndpointManager.class);
    }
}

