/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.zx.sms.config.PropertiesUtils;
import com.zx.sms.connect.manager.ExitUnlimitCirclePolicy;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EventLoopGroupFactory {
    INS;

    private static final Logger logger;
    private static final String OS_NAME;
    private static boolean isLinuxPlatform;
    private static boolean isWindowsPlatform;
    private static final RejectedExecutionHandler rejected;
    private static final EventLoopGroup bossGroup;
    private static final EventLoopGroup workgroup;
    private static final ListeningScheduledExecutorService busiWork;

    private static boolean useEpoll() {
        return EventLoopGroupFactory.isLinuxPlatform() && Epoll.isAvailable();
    }

    private static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    private static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    private static EventLoopGroup buildEventLoopGroup(int nthread, String threadName) {
        if (EventLoopGroupFactory.useEpoll()) {
            String sThreadName = "Epoll" + threadName;
            logger.info("create EpollEventLoopGroup,Name : {}", (Object)sThreadName);
            return new EpollEventLoopGroup(nthread, EventLoopGroupFactory.newThreadFactory(sThreadName));
        }
        String sThreadName = "Nio" + threadName;
        logger.info("create NioEventLoopGroup,Name : {}", (Object)sThreadName);
        return new NioEventLoopGroup(nthread, EventLoopGroupFactory.newThreadFactory(sThreadName));
    }

    public static <C extends ServerChannel> Class<C> selectServerChannelClass() {
        if (EventLoopGroupFactory.useEpoll()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static <C extends Channel> Class<C> selectChannelClass() {
        if (EventLoopGroupFactory.useEpoll()) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public EventLoopGroup getBoss() {
        return bossGroup;
    }

    public EventLoopGroup getWorker() {
        return workgroup;
    }

    public ListeningScheduledExecutorService getBusiWork() {
        return busiWork;
    }

    public <T> void submitUnlimitCircleTask(Callable<T> task, ExitUnlimitCirclePolicy<T> exitCondition, long delay) {
        this.addtask(busiWork, task, exitCondition, delay);
    }

    private <T> void addtask(final ListeningScheduledExecutorService executor, final Callable<T> task, final ExitUnlimitCirclePolicy<T> exitCondition, final long delay) {
        if (executor.isShutdown()) {
            return;
        }
        final ListenableScheduledFuture future = executor.schedule(task, delay, TimeUnit.MILLISECONDS);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                DefaultPromise nettyfuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
                try {
                    nettyfuture.setSuccess(future.get());
                }
                catch (InterruptedException e) {
                    nettyfuture.tryFailure((Throwable)e);
                }
                catch (ExecutionException e) {
                    nettyfuture.tryFailure((Throwable)e);
                }
                catch (Exception e) {
                    nettyfuture.tryFailure((Throwable)e);
                }
                try {
                    if (exitCondition.notOver(nettyfuture)) {
                        EventLoopGroupFactory.this.addtask(executor, task, exitCondition, delay);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, (Executor)executor);
    }

    public void closeAll() {
        this.getBusiWork().shutdown();
        this.getBoss().shutdownGracefully().syncUninterruptibly();
        this.getWorker().shutdownGracefully().syncUninterruptibly();
    }

    private static ThreadFactory newThreadFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    static {
        logger = LoggerFactory.getLogger(EventLoopGroupFactory.class);
        OS_NAME = System.getProperty("os.name");
        isLinuxPlatform = false;
        isWindowsPlatform = false;
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("linux")) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("windows")) {
            isWindowsPlatform = true;
        }
        rejected = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        };
        bossGroup = EventLoopGroupFactory.buildEventLoopGroup(1, "bossGroup");
        workgroup = EventLoopGroupFactory.buildEventLoopGroup(0, "workGroup");
        busiWork = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(Integer.parseInt(PropertiesUtils.getProperties("GlobalBusiWorkThreadCount", "4")), EventLoopGroupFactory.newThreadFactory("busiWork-"), rejected));
    }
}

