/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.cmpp;

import com.zx.sms.common.GlobalConstance;
import com.zx.sms.connect.manager.AbstractClientEndpointConnector;
import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.cmpp.CMPPClientEndpointEntity;
import com.zx.sms.connect.manager.cmpp.CMPPCodecChannelInitializer;
import com.zx.sms.connect.manager.cmpp.CMPPEndpointEntity;
import com.zx.sms.handler.cmpp.CMPPDeliverLongMessageHandler;
import com.zx.sms.handler.cmpp.CMPPSubmitLongMessageHandler;
import com.zx.sms.handler.cmpp.ReWriteSubmitMsgSrcHandler;
import com.zx.sms.session.AbstractSessionStateManager;
import com.zx.sms.session.cmpp.SessionLoginManager;
import com.zx.sms.session.cmpp.SessionStateManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPPClientEndpointConnector
extends AbstractClientEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(CMPPClientEndpointConnector.class);

    public CMPPClientEndpointConnector(CMPPClientEndpointEntity e) {
        super(e);
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity cmppentity) {
        CMPPEndpointEntity entity = (CMPPEndpointEntity)cmppentity;
        if (entity instanceof ClientEndpoint) {
            pipe.addAfter("codecName", "reWriteSubmitMsgSrcHandler", (ChannelHandler)new ReWriteSubmitMsgSrcHandler(entity));
        }
        pipe.addLast("CMPPDeliverLongMessageHandler", (ChannelHandler)new CMPPDeliverLongMessageHandler(entity));
        pipe.addLast("CMPPSubmitLongMessageHandler", (ChannelHandler)new CMPPSubmitLongMessageHandler(entity));
        pipe.addLast("CmppActiveTestRequestMessageHandler", (ChannelHandler)GlobalConstance.activeTestHandler);
        pipe.addLast("CmppActiveTestResponseMessageHandler", (ChannelHandler)GlobalConstance.activeTestRespHandler);
        pipe.addLast("CmppTerminateRequestMessageHandler", (ChannelHandler)GlobalConstance.terminateHandler);
        pipe.addLast("CmppTerminateResponseMessageHandler", (ChannelHandler)GlobalConstance.terminateRespHandler);
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        CMPPCodecChannelInitializer codec = null;
        EndpointEntity entity = this.getEndpointEntity();
        if (entity instanceof CMPPEndpointEntity) {
            pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)((CMPPEndpointEntity)this.getEndpointEntity()).getIdleTimeSec(), TimeUnit.SECONDS));
            codec = new CMPPCodecChannelInitializer(((CMPPEndpointEntity)this.getEndpointEntity()).getVersion());
        } else {
            pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, 30L, TimeUnit.SECONDS));
            codec = new CMPPCodecChannelInitializer();
        }
        pipeline.addLast("CmppServerIdleStateHandler", (ChannelHandler)GlobalConstance.idleHandler);
        pipeline.addLast(codec.pipeName(), (ChannelHandler)codec);
        pipeline.addLast("sessionLoginManager", (ChannelHandler)new SessionLoginManager(this.getEndpointEntity()));
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return new SessionStateManager(entity, storeMap, preSend);
    }
}

