/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.cmpp;

import com.zx.sms.codec.cmpp.CMPPMessageCodecAggregator;
import com.zx.sms.codec.cmpp.CmppHeaderCodec;
import com.zx.sms.codec.cmpp20.CMPP20MessageCodecAggregator;
import com.zx.sms.codec.cmpp7F.CMPP7FMessageCodecAggregator;
import com.zx.sms.common.NotSupportedException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPPCodecChannelInitializer
extends ChannelInitializer<Channel> {
    private static final Logger logger = LoggerFactory.getLogger(CMPPCodecChannelInitializer.class);
    private int version;
    private static final int defaultVersion = 48;

    public CMPPCodecChannelInitializer() {
        this.version = 48;
    }

    public CMPPCodecChannelInitializer(int version) {
        this.version = version;
    }

    public static String pipeName() {
        return "cmppCodec";
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addBefore(CMPPCodecChannelInitializer.pipeName(), "FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(4096, 0, 4, -4, 0, true));
        pipeline.addBefore(CMPPCodecChannelInitializer.pipeName(), "CmppHeaderCodec", (ChannelHandler)new CmppHeaderCodec());
        pipeline.addBefore(CMPPCodecChannelInitializer.pipeName(), "codecName", (ChannelHandler)CMPPCodecChannelInitializer.getCodecHandler(this.version));
    }

    public static ChannelDuplexHandler getCodecHandler(int version) throws Exception {
        if ((long)version == 48L) {
            return CMPPMessageCodecAggregator.getInstance();
        }
        if ((long)version == 32L) {
            return CMPP20MessageCodecAggregator.getInstance();
        }
        if ((long)version == 127L) {
            return CMPP7FMessageCodecAggregator.getInstance();
        }
        logger.error("not supported protocol version: {}", (Object)version);
        throw new NotSupportedException("not supported protocol version.");
    }
}

