/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.cmpp;

import com.zx.sms.common.GlobalConstance;
import com.zx.sms.connect.manager.AbstractServerEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.cmpp.CMPPCodecChannelInitializer;
import com.zx.sms.connect.manager.cmpp.CMPPEndpointEntity;
import com.zx.sms.session.cmpp.SessionLoginManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPPServerEndpointConnector
extends AbstractServerEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(CMPPServerEndpointConnector.class);

    public CMPPServerEndpointConnector(EndpointEntity e) {
        super(e);
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        super.doinitPipeLine(pipeline);
        CMPPCodecChannelInitializer codec = null;
        if (this.getEndpointEntity() instanceof CMPPEndpointEntity) {
            pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)this.getEndpointEntity().getIdleTimeSec(), TimeUnit.SECONDS));
            codec = new CMPPCodecChannelInitializer(((CMPPEndpointEntity)this.getEndpointEntity()).getVersion());
        } else {
            pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, 30L, TimeUnit.SECONDS));
            codec = new CMPPCodecChannelInitializer();
        }
        pipeline.addLast("CmppServerIdleStateHandler", (ChannelHandler)GlobalConstance.idleHandler);
        pipeline.addLast(codec.pipeName(), (ChannelHandler)codec);
        pipeline.addLast("sessionLoginManager", (ChannelHandler)new SessionLoginManager(this.getEndpointEntity()));
    }
}

