/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.sgip;

import com.zx.sms.common.GlobalConstance;
import com.zx.sms.connect.manager.AbstractClientEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.sgip.SgipCodecChannelInitializer;
import com.zx.sms.connect.manager.sgip.SgipEndpointEntity;
import com.zx.sms.handler.sgip.ReWriteNodeIdHandler;
import com.zx.sms.handler.sgip.SgipDeliverLongMessageHandler;
import com.zx.sms.handler.sgip.SgipSubmitLongMessageHandler;
import com.zx.sms.handler.sgip.SgipUnbindRequestMessageHandler;
import com.zx.sms.handler.sgip.SgipUnbindResponseMessageHandler;
import com.zx.sms.session.AbstractSessionStateManager;
import com.zx.sms.session.sgip.SgipSessionLoginManager;
import com.zx.sms.session.sgip.SgipSessionStateManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SgipClientEndpointConnector
extends AbstractClientEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(SgipClientEndpointConnector.class);

    public SgipClientEndpointConnector(EndpointEntity endpoint) {
        super(endpoint);
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return new SgipSessionStateManager(entity, storeMap, preSend);
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity entity) {
        pipe.addLast("reWriteNodeIdHandler", (ChannelHandler)new ReWriteNodeIdHandler((SgipEndpointEntity)entity));
        pipe.addLast("SgipDeliverLongMessageHandler", (ChannelHandler)new SgipDeliverLongMessageHandler(entity));
        pipe.addLast("SgipSubmitLongMessageHandler", (ChannelHandler)new SgipSubmitLongMessageHandler(entity));
        pipe.addLast("SgipUnbindResponseMessageHandler", (ChannelHandler)new SgipUnbindResponseMessageHandler());
        pipe.addLast("SgipUnbindRequestMessageHandler", (ChannelHandler)new SgipUnbindRequestMessageHandler());
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        EndpointEntity entity = this.getEndpointEntity();
        pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)entity.getIdleTimeSec(), TimeUnit.SECONDS));
        pipeline.addLast("SgipServerIdleStateHandler", (ChannelHandler)GlobalConstance.sgipidleHandler);
        pipeline.addLast(SgipCodecChannelInitializer.pipeName(), (ChannelHandler)new SgipCodecChannelInitializer());
        pipeline.addLast("sessionLoginManager", (ChannelHandler)new SgipSessionLoginManager(this.getEndpointEntity()));
    }
}

