/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.smpp;

import com.zx.sms.common.GlobalConstance;
import com.zx.sms.connect.manager.AbstractClientEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.smpp.SMPPCodecChannelInitializer;
import com.zx.sms.handler.smpp.AddZeroByteHandler;
import com.zx.sms.handler.smpp.EnquireLinkMessageHandler;
import com.zx.sms.handler.smpp.EnquireLinkRespMessageHandler;
import com.zx.sms.handler.smpp.SMPPLongMessageHandler;
import com.zx.sms.handler.smpp.UnbindMessageHandler;
import com.zx.sms.handler.smpp.UnbindRespMessageHandler;
import com.zx.sms.session.AbstractSessionStateManager;
import com.zx.sms.session.smpp.SMPPSessionLoginManager;
import com.zx.sms.session.smpp.SMPPSessionStateManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPClientEndpointConnector
extends AbstractClientEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(SMPPClientEndpointConnector.class);

    public SMPPClientEndpointConnector(EndpointEntity endpoint) {
        super(endpoint);
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return new SMPPSessionStateManager(entity, storeMap, preSend);
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity entity) {
        pipe.addAfter("codecName", "AddZeroByteHandler", (ChannelHandler)new AddZeroByteHandler(entity));
        pipe.addLast("SMPPLongMessageHandler", (ChannelHandler)new SMPPLongMessageHandler(entity));
        pipe.addLast("EnquireLinkMessageHandler", (ChannelHandler)new EnquireLinkMessageHandler());
        pipe.addLast("EnquireLinkRespMessageHandler", (ChannelHandler)new EnquireLinkRespMessageHandler());
        pipe.addLast("UnbindRespMessageHandler", (ChannelHandler)new UnbindRespMessageHandler());
        pipe.addLast("UnbindMessageHandler", (ChannelHandler)new UnbindMessageHandler());
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        EndpointEntity entity = this.getEndpointEntity();
        pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)entity.getIdleTimeSec(), TimeUnit.SECONDS));
        pipeline.addLast("SmppServerIdleStateHandler", (ChannelHandler)GlobalConstance.smppidleHandler);
        pipeline.addLast(SMPPCodecChannelInitializer.pipeName(), (ChannelHandler)new SMPPCodecChannelInitializer());
        pipeline.addLast("sessionLoginManager", (ChannelHandler)new SMPPSessionLoginManager(this.getEndpointEntity()));
    }
}

