/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.handler.smpp;

import com.zx.sms.codec.smpp.msg.BaseSm;
import com.zx.sms.codec.smpp.msg.DeliverSm;
import com.zx.sms.codec.smpp.msg.SubmitSm;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.smpp.SMPPEndpointEntity;
import com.zx.sms.handler.api.AbstractBusinessHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddZeroByteHandler
extends AbstractBusinessHandler {
    private static final Logger logger = LoggerFactory.getLogger(AddZeroByteHandler.class);

    public AddZeroByteHandler(EndpointEntity entity) {
        this.setEndpointEntity(entity);
    }

    @Override
    public String name() {
        return "AddZeroByteHandler";
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        BaseSm basemsg;
        short l;
        SMPPEndpointEntity smppendpoit;
        if (this.getEndpointEntity() instanceof SMPPEndpointEntity && (smppendpoit = (SMPPEndpointEntity)this.getEndpointEntity()).isAddZeroByte() && (msg instanceof DeliverSm || msg instanceof SubmitSm) && (l = (basemsg = (BaseSm)msg).getMsglength()) > 0) {
            byte[] newbyte = new byte[l - 1];
            if (newbyte.length > 0) {
                System.arraycopy(basemsg.getShortMessage(), 0, newbyte, 0, l - 1);
            }
            basemsg.setShortMessage(newbyte);
            basemsg.setMsglength((short)newbyte.length);
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        SMPPEndpointEntity smppendpoit;
        if (this.getEndpointEntity() instanceof SMPPEndpointEntity && (smppendpoit = (SMPPEndpointEntity)this.getEndpointEntity()).isAddZeroByte() && (msg instanceof DeliverSm || msg instanceof SubmitSm)) {
            BaseSm basemsg = (BaseSm)msg;
            short l = basemsg.getMsglength();
            if (l < 255) {
                byte[] newbyte = new byte[l + 1];
                System.arraycopy(basemsg.getShortMessage(), 0, newbyte, 0, l);
                newbyte[l] = 0;
                basemsg.setShortMessage(newbyte);
                basemsg.setMsglength((short)newbyte.length);
            } else {
                basemsg.getShortMessage()[l - 1] = 0;
            }
        }
        ctx.write(msg, promise);
    }
}

