/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session;

import com.zx.sms.BaseMessage;
import com.zx.sms.common.util.ByteArrayUtil;
import com.zx.sms.common.util.IPRange;
import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManager;
import com.zx.sms.session.cmpp.SessionState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionLoginManager
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionLoginManager.class);
    private static final Pattern p = Pattern.compile("[0-9]+\\s*:\\s*([0-9]+)");
    protected EndpointEntity entity;
    protected SessionState state = SessionState.DisConnect;

    public AbstractSessionLoginManager(EndpointEntity entity) {
        this.entity = entity;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.state == SessionState.DisConnect) {
            String exceptionMsg = cause.getMessage();
            if (cause instanceof TooLongFrameException && exceptionMsg != null) {
                Matcher matcher = p.matcher(exceptionMsg);
                if (matcher.find()) {
                    String length = matcher.group(1);
                    byte[] chars = ByteArrayUtil.toByteArray(Long.parseLong(length));
                    logger.error("login error entity : " + this.entity.toString() + ".\nthis request maybe HTTP. receive first 4 byte is :\"" + new String(chars).trim() + "\" .", cause);
                } else {
                    logger.error("login error entity : " + this.entity.toString(), cause);
                }
            } else {
                logger.error("login error entity : " + this.entity.toString(), cause);
            }
            ctx.close();
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.state == SessionState.DisConnect) {
            if (this.entity instanceof ClientEndpoint) {
                this.receiveConnectResponseMessage(ctx, msg);
            } else {
                this.receiveConnectMessage(ctx, msg);
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        if (this.state == SessionState.Connect) {
            Object conn = this.entity.getSingletonConnector();
            if (conn != null) {
                conn.removeChannel(ch);
            }
            logger.warn("Connection closed . {} , connect count : {}", (Object)this.entity, (Object)(conn == null ? 0 : conn.getConnectionNum()));
        } else {
            logger.warn("session is not created. the entity is {}.channel remote is {}", (Object)this.entity, (Object)ctx.channel().remoteAddress());
        }
        ctx.fireChannelInactive();
    }

    protected abstract BaseMessage createLoginRequest();

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.state == SessionState.DisConnect && this.entity instanceof ClientEndpoint) {
            BaseMessage loginRequest = this.createLoginRequest();
            ctx.channel().writeAndFlush((Object)loginRequest);
            logger.info("session Start : Send to {} Login Message : {}", (Object)this.entity, (Object)loginRequest);
        }
        ctx.fireChannelActive();
    }

    protected abstract EndpointEntity queryEndpointEntityByMsg(Object var1);

    protected abstract boolean validAddressHost(EndpointEntity var1, Channel var2);

    protected abstract int validClientMsg(EndpointEntity var1, Object var2);

    protected abstract int validServermsg(Object var1);

    protected abstract void changeProtoVersion(ChannelHandlerContext var1, EndpointEntity var2, Object var3) throws Exception;

    protected abstract void doLoginSuccess(ChannelHandlerContext var1, EndpointEntity var2, Object var3);

    protected abstract void failedLogin(ChannelHandlerContext var1, Object var2, long var3);

    private boolean validRemoteAddress(EndpointEntity childentity, Channel channel) {
        InetSocketAddress remoteAddr = (InetSocketAddress)channel.remoteAddress();
        List<String> allowed = childentity.getAllowedAddr();
        if (allowed != null && !allowed.isEmpty()) {
            boolean isallow = false;
            for (String strIp : allowed) {
                if (!StringUtils.isNotBlank((CharSequence)strIp)) continue;
                try {
                    IPRange r = new IPRange(strIp.trim());
                    if (!r.isInRange(remoteAddr.getAddress())) continue;
                    isallow = true;
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                }
            }
            if (!isallow) {
                return false;
            }
        }
        return this.validAddressHost(childentity, channel);
    }

    protected void receiveConnectMessage(ChannelHandlerContext ctx, Object message) throws Exception {
        EndpointEntity childentity = this.queryEndpointEntityByMsg(message);
        this.changeProtoVersion(ctx, childentity, message);
        if (childentity == null) {
            this.failedLogin(ctx, message, 3L);
            return;
        }
        if (!this.validRemoteAddress(childentity, ctx.channel())) {
            this.failedLogin(ctx, message, 2L);
            return;
        }
        int status = this.validClientMsg(childentity, message);
        if (status == 0) {
            EndpointEntity oldEntity;
            EndpointManager.INS.openEndpoint(childentity);
            this.entity = oldEntity = EndpointManager.INS.getEndpointEntity(childentity.getId());
            Object conn = oldEntity.getSingletonConnector();
            if (conn.addChannel(ctx.channel())) {
                IdleStateHandler idlehandler = (IdleStateHandler)ctx.pipeline().get("IdleStateHandler");
                ctx.pipeline().replace((ChannelHandler)idlehandler, "IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)oldEntity.getIdleTimeSec(), TimeUnit.SECONDS));
                this.state = SessionState.Connect;
                this.doLoginSuccess(ctx, oldEntity, message);
                this.notifyChannelConnected(ctx);
                logger.info("{} login success on channel {}", (Object)oldEntity.getId(), (Object)ctx.channel());
            } else {
                this.failedLogin(ctx, message, 5L);
            }
        } else {
            this.failedLogin(ctx, message, status);
        }
    }

    private void receiveConnectResponseMessage(ChannelHandlerContext ctx, Object message) throws Exception {
        int status = this.validServermsg(message);
        if (status == 0) {
            Object conn = this.entity.getSingletonConnector();
            if (!conn.addChannel(ctx.channel())) {
                ctx.close();
                return;
            }
        } else {
            logger.info("{} login failed (status = {}) on channel {}", new Object[]{this.entity.getId(), status, ctx.channel()});
            ctx.close();
            return;
        }
        this.state = SessionState.Connect;
        this.notifyChannelConnected(ctx);
        logger.info("{} login success on channel {}", (Object)this.entity.getId(), (Object)ctx.channel());
    }

    private void notifyChannelConnected(ChannelHandlerContext ctx) {
        ctx.channel().pipeline().fireUserEventTriggered((Object)SessionState.Connect);
    }
}

