/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session.cmpp;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.zx.sms.BaseMessage;
import com.zx.sms.codec.cmpp.msg.CmppConnectRequestMessage;
import com.zx.sms.codec.cmpp.msg.CmppConnectResponseMessage;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.ServerEndpoint;
import com.zx.sms.connect.manager.cmpp.CMPPCodecChannelInitializer;
import com.zx.sms.connect.manager.cmpp.CMPPEndpointEntity;
import com.zx.sms.connect.manager.cmpp.CMPPServerChildEndpointEntity;
import com.zx.sms.session.AbstractSessionLoginManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLoginManager
extends AbstractSessionLoginManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionLoginManager.class);

    public SessionLoginManager(EndpointEntity entity) {
        super(entity);
    }

    private int validClientMsg(CmppConnectRequestMessage message, CMPPServerChildEndpointEntity entity) throws Exception {
        byte[] userBytes = entity.getUserName().getBytes(entity.getChartset());
        byte[] passwdBytes = entity.getPassword().getBytes(entity.getChartset());
        byte[] timestampBytes = String.format("%010d", message.getTimestamp()).getBytes(entity.getChartset());
        byte[] authBytes = DigestUtils.md5((byte[])Bytes.concat((byte[][])new byte[][]{userBytes, new byte[9], passwdBytes, timestampBytes}));
        if (Arrays.equals(authBytes, message.getAuthenticatorSource())) {
            return 0;
        }
        logger.error("AuthenticatorSource valided failed.s:{},c:{}", (Object)Hex.encodeHexString((byte[])authBytes), (Object)Hex.encodeHexString((byte[])message.getAuthenticatorSource()));
        return 3;
    }

    @Override
    protected BaseMessage createLoginRequest() {
        CMPPEndpointEntity cliententity = (CMPPEndpointEntity)this.entity;
        CmppConnectRequestMessage req = new CmppConnectRequestMessage();
        req.setSourceAddr(cliententity.getUserName());
        String timestamp = DateFormatUtils.format((long)CachedMillisecondClock.INS.now(), (String)"MMddHHmmss");
        req.setTimestamp(Long.parseLong(timestamp));
        byte[] userBytes = cliententity.getUserName().getBytes(cliententity.getChartset());
        byte[] passwdBytes = cliententity.getPassword().getBytes(cliententity.getChartset());
        byte[] timestampBytes = timestamp.getBytes(cliententity.getChartset());
        req.setAuthenticatorSource(DigestUtils.md5((byte[])Bytes.concat((byte[][])new byte[][]{userBytes, new byte[9], passwdBytes, timestampBytes})));
        req.setVersion(cliententity.getVersion());
        return req;
    }

    @Override
    protected EndpointEntity queryEndpointEntityByMsg(Object msg) {
        if (msg instanceof CmppConnectRequestMessage) {
            CmppConnectRequestMessage message = (CmppConnectRequestMessage)msg;
            String username = message.getSourceAddr();
            if (this.entity instanceof ServerEndpoint) {
                ServerEndpoint serverEntity = (ServerEndpoint)((Object)this.entity);
                return serverEntity.getChild(username.trim());
            }
        }
        return null;
    }

    @Override
    protected boolean validAddressHost(EndpointEntity childentity, Channel channel) {
        return true;
    }

    @Override
    protected int validClientMsg(EndpointEntity entity, Object message) {
        try {
            return this.validClientMsg((CmppConnectRequestMessage)message, (CMPPServerChildEndpointEntity)entity);
        }
        catch (Exception e) {
            logger.error("AuthenticatorSource valided failed", (Throwable)e);
            return 3;
        }
    }

    @Override
    protected int validServermsg(Object message) {
        if (message instanceof CmppConnectResponseMessage) {
            CmppConnectResponseMessage resp = (CmppConnectResponseMessage)message;
            return (int)resp.getStatus();
        }
        logger.error("connect msg type error : {}", message);
        return 9;
    }

    @Override
    protected void changeProtoVersion(ChannelHandlerContext ctx, EndpointEntity entity, Object msg) throws Exception {
        CMPPServerChildEndpointEntity childentity;
        short clientVersion;
        CmppConnectRequestMessage message = (CmppConnectRequestMessage)msg;
        short aim_ver = clientVersion = message.getVersion();
        if (entity != null && (aim_ver = (childentity = (CMPPServerChildEndpointEntity)entity).getVersion()) != clientVersion) {
            logger.warn("receive version code {} ,expected version is {} .I would use version {}", new Object[]{clientVersion, aim_ver, aim_ver});
        }
        if (48 != aim_ver) {
            logger.info("changeCodec to version:{}", (Object)aim_ver);
            ctx.pipeline().replace("codecName", "codecName", (ChannelHandler)CMPPCodecChannelInitializer.getCodecHandler(aim_ver));
        }
    }

    @Override
    protected void doLoginSuccess(ChannelHandlerContext ctx, EndpointEntity entity, Object msg) {
        CMPPServerChildEndpointEntity childentity = (CMPPServerChildEndpointEntity)entity;
        CmppConnectRequestMessage message = (CmppConnectRequestMessage)msg;
        CmppConnectResponseMessage resp = new CmppConnectResponseMessage(message.getHeader().getSequenceId());
        resp.setVersion(childentity.getVersion());
        resp.setStatus(0L);
        resp.setAuthenticatorISMG(DigestUtils.md5((byte[])Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)((int)resp.getStatus())), message.getAuthenticatorSource(), childentity.getPassword().getBytes(childentity.getChartset())})));
        ctx.channel().writeAndFlush((Object)resp);
    }

    @Override
    protected void failedLogin(ChannelHandlerContext ctx, Object msg, long status) {
        if (msg instanceof CmppConnectRequestMessage) {
            logger.error("Connected error status :{},msg : {}", (Object)status, msg);
            CmppConnectRequestMessage message = (CmppConnectRequestMessage)msg;
            CmppConnectResponseMessage resp = new CmppConnectResponseMessage(message.getHeader().getSequenceId());
            resp.setAuthenticatorISMG(new byte[16]);
            resp.setStatus(status);
            ChannelFuture promise = ctx.writeAndFlush((Object)resp);
            final ChannelHandlerContext finalctx = ctx;
            promise.addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    finalctx.close();
                }
            });
        } else {
            logger.error("connect msg type error : {}", msg);
            ctx.close();
        }
    }
}

