/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session.sgip;

import com.zx.sms.BaseMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.sgip12.msg.SgipBindRequestMessage;
import com.zx.sms.codec.sgip12.msg.SgipBindResponseMessage;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.sgip.SgipEndpointEntity;
import com.zx.sms.connect.manager.sgip.SgipServerEndpointEntity;
import com.zx.sms.session.AbstractSessionLoginManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SgipSessionLoginManager
extends AbstractSessionLoginManager {
    private static final Logger logger = LoggerFactory.getLogger(SgipSessionLoginManager.class);

    public SgipSessionLoginManager(EndpointEntity entity) {
        super(entity);
    }

    @Override
    protected BaseMessage createLoginRequest() {
        SgipEndpointEntity sgipentity = (SgipEndpointEntity)this.entity;
        SgipBindRequestMessage bind = this.createBindRequest(sgipentity);
        return bind;
    }

    @Override
    protected EndpointEntity queryEndpointEntityByMsg(Object msg) {
        if (msg instanceof SgipBindRequestMessage) {
            SgipBindRequestMessage message = (SgipBindRequestMessage)msg;
            String username = message.getLoginName();
            if (this.entity instanceof SgipServerEndpointEntity) {
                SgipServerEndpointEntity serverEntity = (SgipServerEndpointEntity)this.entity;
                return serverEntity.getChild(username.trim());
            }
        }
        return null;
    }

    @Override
    protected boolean validAddressHost(EndpointEntity childentity, Channel channel) {
        return true;
    }

    @Override
    protected int validClientMsg(EndpointEntity entity, Object msg) {
        SgipEndpointEntity sgipentity = (SgipEndpointEntity)entity;
        SgipBindRequestMessage message = (SgipBindRequestMessage)msg;
        if (sgipentity.getLoginName().equals(message.getLoginName()) && sgipentity.getLoginPassowrd().equals(message.getLoginPassowrd())) {
            return 0;
        }
        return 1;
    }

    @Override
    protected int validServermsg(Object message) {
        if (message instanceof SgipBindResponseMessage) {
            SgipBindResponseMessage resp = (SgipBindResponseMessage)message;
            return resp.getResult();
        }
        logger.error("connect msg type error : {}", message);
        return 9;
    }

    @Override
    protected void changeProtoVersion(ChannelHandlerContext ctx, EndpointEntity entity, Object message) throws Exception {
    }

    @Override
    protected void doLoginSuccess(ChannelHandlerContext ctx, EndpointEntity entity, Object message) {
        SgipEndpointEntity sgipentity = (SgipEndpointEntity)entity;
        SgipBindResponseMessage resp = new SgipBindResponseMessage(((Message)message).getHeader());
        resp.setResult((short)0);
        resp.setTimestamp(((Message)message).getTimestamp());
        ctx.channel().writeAndFlush((Object)resp);
    }

    @Override
    protected void failedLogin(ChannelHandlerContext ctx, Object msg, long status) {
        if (msg instanceof SgipBindRequestMessage) {
            logger.error("Connected error status :{},msg : {}", (Object)status, msg);
            SgipBindRequestMessage message = (SgipBindRequestMessage)msg;
            SgipBindResponseMessage resp = new SgipBindResponseMessage(message.getHeader());
            resp.setResult((short)status);
            resp.setTimestamp(message.getTimestamp());
            ChannelFuture promise = ctx.writeAndFlush((Object)resp);
            final ChannelHandlerContext finalctx = ctx;
            promise.addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    finalctx.close();
                }
            });
        } else {
            logger.error("connect msg type error : {}", msg);
            ctx.close();
        }
    }

    private SgipBindRequestMessage createBindRequest(SgipEndpointEntity entity) {
        SgipBindRequestMessage req = new SgipBindRequestMessage();
        req.setLoginName(entity.getLoginName());
        req.setLoginPassowrd(entity.getLoginPassowrd());
        req.getHeader().setNodeId(entity.getNodeId());
        if (entity.getChannelType() == EndpointEntity.ChannelType.UP) {
            req.setLoginType((short)2);
        } else if (entity.getChannelType() == EndpointEntity.ChannelType.DOWN) {
            req.setLoginType((short)1);
        }
        return req;
    }
}

