/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session.sgip;

import com.zx.sms.codec.cmpp.msg.DefaultMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.sgip12.msg.SgipDeliverResponseMessage;
import com.zx.sms.codec.sgip12.msg.SgipSubmitResponseMessage;
import com.zx.sms.common.storedMap.VersionObject;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.sgip.SgipEndpointEntity;
import com.zx.sms.session.AbstractSessionStateManager;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SgipSessionStateManager
extends AbstractSessionStateManager<Long, Message> {
    private static final Logger logger = LoggerFactory.getLogger(SgipSessionStateManager.class);

    public SgipSessionStateManager(EndpointEntity entity, ConcurrentMap<Long, VersionObject<Message>> storeMap, boolean preSend) {
        super(entity, storeMap, preSend);
    }

    @Override
    protected Long getSequenceId(Message msg) {
        long seq = msg.getHeader().getSequenceId();
        long time = msg.getTimestamp();
        long node = msg.getHeader().getNodeId();
        return node << 32 | seq & 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    protected boolean needSendAgainByResponse(Message req, Message res) {
        short result = 0;
        if (res instanceof SgipSubmitResponseMessage) {
            result = ((SgipSubmitResponseMessage)res).getResult();
        } else if (res instanceof SgipDeliverResponseMessage) {
            result = ((SgipDeliverResponseMessage)res).getResult();
        }
        if (result != 0 && result != 88) {
            logger.error("Entity {} Receive Err Response result: {} . Req: {} ,Resp:{}", new Object[]{this.getEntity().getId(), result, req, res});
        }
        return result == 88;
    }

    @Override
    protected boolean closeWhenRetryFailed(Message req) {
        return this.getEntity().isCloseWhenRetryFailed();
    }

    @Override
    public Promise<Message> writeMessagesync(Message msg) {
        DefaultMessage message;
        SgipEndpointEntity entity = (SgipEndpointEntity)this.getEntity();
        if (msg instanceof DefaultMessage && entity instanceof SgipEndpointEntity && (message = (DefaultMessage)msg).isRequest() && entity.getNodeId() != 0L && message.getHeader().getNodeId() == 0L) {
            message.getHeader().setNodeId(entity.getNodeId());
        }
        return super.writeMessagesync(msg);
    }
}

