/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session.smgp;

import com.zx.sms.codec.smgp.msg.SMGPActiveTestMessage;
import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.msg.SMGPDeliverRespMessage;
import com.zx.sms.codec.smgp.msg.SMGPSubmitRespMessage;
import com.zx.sms.common.storedMap.VersionObject;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.session.AbstractSessionStateManager;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPSessionStateManager
extends AbstractSessionStateManager<Integer, SMGPBaseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(SMGPSessionStateManager.class);

    public SMGPSessionStateManager(EndpointEntity entity, ConcurrentMap<Integer, VersionObject<SMGPBaseMessage>> storeMap, boolean preSend) {
        super(entity, storeMap, preSend);
    }

    @Override
    protected Integer getSequenceId(SMGPBaseMessage msg) {
        return msg.getSequenceNo();
    }

    @Override
    protected boolean needSendAgainByResponse(SMGPBaseMessage req, SMGPBaseMessage res) {
        int result = 0;
        if (res instanceof SMGPSubmitRespMessage) {
            SMGPSubmitRespMessage submitresp = (SMGPSubmitRespMessage)res;
            result = submitresp.getStatus();
        } else if (res instanceof SMGPDeliverRespMessage) {
            SMGPDeliverRespMessage deliRes = (SMGPDeliverRespMessage)res;
            result = deliRes.getStatus();
        }
        if (result != 0) {
            logger.error("Entity {} Receive Err Response result: {} . Req: {} ,Resp:{}", new Object[]{this.getEntity().getId(), result, req, res});
        }
        return false;
    }

    @Override
    protected boolean closeWhenRetryFailed(SMGPBaseMessage req) {
        if (req instanceof SMGPActiveTestMessage) {
            return true;
        }
        return this.getEntity().isCloseWhenRetryFailed();
    }
}

