/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlLiterals;

public class WbXmlContent {
    private WbXmlElement element = null;
    private String string = null;
    private WbXmlAttribute pi = null;

    protected WbXmlContent() {
    }

    public WbXmlContent(WbXmlElement element) {
        this();
        this.setElement(element);
    }

    public WbXmlContent(String string) {
        this();
        this.setString(string);
    }

    public WbXmlContent(WbXmlAttribute pi) {
        this();
        this.setPi(pi);
    }

    public final WbXmlContent setElement(WbXmlElement element) {
        this.string = null;
        this.pi = null;
        this.element = element;
        return this;
    }

    public final WbXmlContent setString(String string) {
        this.string = string;
        this.pi = null;
        this.element = null;
        return this;
    }

    public final WbXmlContent setPi(WbXmlAttribute pi) {
        this.string = null;
        this.pi = pi;
        this.element = null;
        return this;
    }

    public String getString() {
        return this.string;
    }

    public boolean isString() {
        return this.string != null;
    }

    public boolean isEntity() {
        return this.isString() && this.string.startsWith("&#") && this.string.endsWith(";");
    }

    public long getEntityNumber() {
        if (this.isEntity()) {
            String number = this.string.substring(2, this.string.length() - 1);
            return Long.parseLong(number);
        }
        throw new IllegalStateException(String.format("The value is not an entity: %s", this.string));
    }

    public boolean isPi() {
        return this.pi != null;
    }

    public boolean isElement() {
        return this.element != null;
    }

    public WbXmlElement getElement() {
        return this.element;
    }

    public WbXmlAttribute getPi() {
        return this.pi;
    }

    public boolean isEmpty() {
        return this.string == null && this.pi == null && this.element == null;
    }

    public String toString(int ident) {
        String spaces = WbXmlLiterals.identString(ident);
        StringBuilder sb = new StringBuilder(spaces);
        sb.append(this.getClass().getSimpleName());
        sb.append(": ");
        if (this.string != null) {
            sb.append("str->");
            sb.append(this.string);
            sb.append(System.getProperty("line.separator"));
        } else if (this.pi != null) {
            sb.append("pi->");
            sb.append(this.pi.toString(0));
            sb.append(System.getProperty("line.separator"));
        } else if (this.element != null) {
            sb.append(System.getProperty("line.separator"));
            sb.append(this.element.toString(++ident));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

