/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import es.rickyepoderi.wbxml.stream.events.WbXmlCharactersEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlEndDocumentEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlEndElementEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlStartDocumentEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlStartElementEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WbXmlEventReader
implements XMLEventReader {
    protected static final Logger log = Logger.getLogger(WbXmlEventReader.class.getName());
    private WbXmlStreamReader stream = null;
    private XMLEvent currentEvent = null;
    private XMLEvent nextEvent = null;

    public WbXmlEventReader(WbXmlStreamReader stream) throws XMLStreamException {
        this.stream = stream;
        this.currentEvent = null;
        this.nextEvent = WbXmlEventReader.constructEvent(stream.getEventType(), stream);
    }

    public WbXmlEventReader(WbXmlParser parser) throws XMLStreamException {
        this.stream = new WbXmlStreamReader(parser);
        this.currentEvent = null;
        this.nextEvent = WbXmlEventReader.constructEvent(this.stream.getEventType(), this.stream);
    }

    public WbXmlEventReader(InputStream is) throws IOException, XMLStreamException {
        this(is, null);
    }

    public WbXmlEventReader(InputStream is, WbXmlDefinition definition) throws IOException, XMLStreamException {
        this.stream = new WbXmlStreamReader(is, definition);
        this.currentEvent = null;
        this.nextEvent = WbXmlEventReader.constructEvent(this.stream.getEventType(), this.stream);
    }

    public WbXmlParser getParser() {
        return this.stream.getParser();
    }

    private static XMLEvent constructEvent(int eventType, WbXmlStreamReader stream) throws XMLStreamException {
        WbXmlEvent event;
        log.log(Level.FINE, "constructEvent()");
        switch (eventType) {
            case 7: {
                event = new WbXmlStartDocumentEvent(stream);
                break;
            }
            case 8: {
                event = new WbXmlEndDocumentEvent(stream);
                break;
            }
            case 1: {
                event = new WbXmlStartElementEvent(stream);
                break;
            }
            case 2: {
                event = new WbXmlEndElementEvent(stream);
                break;
            }
            case 4: 
            case 12: {
                event = new WbXmlCharactersEvent(stream);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The %i event is not supported yet", eventType));
            }
        }
        log.log(Level.FINE, "constructEvent(): {0}", event);
        return event;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        log.log(Level.FINE, "nextEvent()");
        this.currentEvent = this.nextEvent;
        this.nextEvent = this.currentEvent.getEventType() != 8 ? WbXmlEventReader.constructEvent(this.stream.next(), this.stream) : null;
        log.log(Level.FINE, "nextEvent(): {0}", this.currentEvent);
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() {
        log.log(Level.FINE, "hasNext()");
        boolean result = this.nextEvent != null;
        log.log(Level.FINE, "hasNext(): {0}", result);
        return result;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        log.log(Level.FINE, "peek()");
        if (!this.hasNext()) {
            throw new XMLStreamException("The reader is depleted!");
        }
        log.log(Level.FINE, "peek(): {0}", this.nextEvent);
        return this.nextEvent;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        log.log(Level.FINE, "getElementText()");
        if (!(this.currentEvent instanceof StartElement)) {
            throw new XMLStreamException("Not in a START_ELEMENT!");
        }
        StringBuilder sb = new StringBuilder();
        XMLEvent event = this.nextEvent();
        while (!(event instanceof EndElement)) {
            if (event instanceof Characters) {
                Characters chars = (Characters)event;
                sb.append(chars.getData());
                continue;
            }
            if (!(event instanceof StartElement)) continue;
            throw new XMLStreamException("Another START_ELEMENT found while iterating!");
        }
        log.log(Level.FINE, "getElementText(): {0}", sb.toString());
        return sb.toString();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        log.log(Level.FINE, "nextTag()");
        XMLEvent event = this.nextEvent();
        while (!(event instanceof EndElement) && !(event instanceof StartElement)) {
            Characters chars;
            if (!(event instanceof Characters) || (chars = (Characters)event).isIgnorableWhiteSpace()) continue;
            throw new XMLStreamException("Non-ignorable CHARACTERS found!");
        }
        log.log(Level.FINE, "nextTag(): {0}", event);
        return event;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        log.log(Level.FINE, "getProperty()");
        return this.stream.getProperty(name);
    }

    @Override
    public void close() throws XMLStreamException {
        log.log(Level.FINE, "close()");
        this.stream.close();
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The WbXmlEventReader is not modifiable!");
    }
}

