/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.stream.WbXmlStreamWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WbXmlEventWriter
implements XMLEventWriter {
    protected static final Logger log = Logger.getLogger(WbXmlEventWriter.class.getName());
    private WbXmlStreamWriter stream = null;

    public WbXmlEventWriter(OutputStream os, WbXmlDefinition def, WbXmlEncoder.StrtblType encoderType, boolean skipSpaces, String encoding) {
        this.stream = new WbXmlStreamWriter(os, def, encoderType, skipSpaces, encoding);
    }

    public WbXmlEventWriter(OutputStream os, WbXmlDefinition def, WbXmlEncoder.StrtblType encoderType, boolean skipSpaces) {
        this.stream = new WbXmlStreamWriter(os, def, encoderType, skipSpaces);
    }

    public WbXmlEventWriter(OutputStream os, WbXmlDefinition def) {
        this.stream = new WbXmlStreamWriter(os, def);
    }

    public WbXmlEventWriter(OutputStream os) {
        this.stream = new WbXmlStreamWriter(os);
    }

    @Override
    public void flush() throws XMLStreamException {
        log.log(Level.FINE, "flush()");
        this.stream.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        log.log(Level.FINE, "close()");
        this.stream.close();
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        log.log(Level.FINE, "add() {0}", event);
        switch (event.getEventType()) {
            case 1: {
                StartElement startElement = (StartElement)event;
                this.stream.writeStartElement(startElement.getName().getPrefix(), startElement.getName().getLocalPart(), startElement.getName().getNamespaceURI());
                Iterator<Attribute> ia = startElement.getAttributes();
                while (ia.hasNext()) {
                    Attribute attr = ia.next();
                    this.stream.writeAttribute(attr.getName().getPrefix(), attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                }
                Iterator<Namespace> in = startElement.getNamespaces();
                while (in.hasNext()) {
                    Namespace ns = in.next();
                    this.stream.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                }
                break;
            }
            case 10: {
                Attribute attr = (Attribute)event;
                this.stream.writeAttribute(attr.getName().getPrefix(), attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                break;
            }
            case 2: {
                this.stream.writeEndElement();
                break;
            }
            case 4: 
            case 12: {
                Characters chars = (Characters)event;
                if (chars.isCData()) {
                    this.stream.writeCData(chars.getData());
                    break;
                }
                this.stream.writeCharacters(chars.getData());
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)event;
                this.stream.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)event;
                this.stream.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                break;
            }
            case 8: {
                this.stream.writeEndDocument();
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)event;
                this.stream.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 5: {
                Comment comment = (Comment)event;
                this.stream.writeComment(comment.getText());
                break;
            }
            case 11: {
                DTD dtd = (DTD)event;
                this.stream.writeDTD(dtd.getDocumentTypeDeclaration());
                break;
            }
            case 9: {
                EntityReference ref = (EntityReference)event;
                this.stream.writeEntityRef(ref.getName());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The %i event is not supported yet", event.getEventType()));
            }
        }
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        log.log(Level.FINE, "add() {0}", reader);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            this.add(event);
        }
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        log.log(Level.FINE, "getPrefix() {0}", uri);
        String prefix = this.stream.getPrefix(uri);
        log.log(Level.FINE, "getPrefix(): {0}", prefix);
        return prefix;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        log.log(Level.FINE, "getPrefix() {0} {1}", new Object[]{prefix, uri});
        this.stream.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        log.log(Level.FINE, "setDefaultNamespace() {0}", uri);
        this.stream.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        log.log(Level.FINE, "setNamespaceContext()");
        this.stream.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        log.log(Level.FINE, "getNamespaceContext()");
        return this.stream.getNamespaceContext();
    }
}

