/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.stream.WbXmlEventReader;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class WbXmlInputFactory
extends XMLInputFactory {
    public static String DEFINITION_PROPERTY = "es.rickyepoderi.wbxml.stream.definition";
    private Map<String, Object> props = new HashMap<String, Object>();

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        throw new XMLStreamException("The WBXML is a binary format!");
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        try {
            if (source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                return new WbXmlStreamReader(ss.getInputStream(), (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
            }
            throw new XMLStreamException("WBXML only support StreamSource with InputStream!");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        try {
            return new WbXmlStreamReader(in, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        try {
            return new WbXmlStreamReader(in, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        try {
            return new WbXmlStreamReader(in, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        throw new XMLStreamException("The WBXML is a binary format!");
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        throw new XMLStreamException("The WBXML is a binary format!");
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return new WbXmlEventReader((WbXmlStreamReader)reader);
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        try {
            if (source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                return new WbXmlEventReader(ss.getInputStream(), (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
            }
            throw new XMLStreamException("WBXML only support StreamSource with InputStream!");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        try {
            return new WbXmlEventReader(in, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream in, String encoding) throws XMLStreamException {
        try {
            return new WbXmlEventReader(in, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream in) throws XMLStreamException {
        try {
            return new WbXmlEventReader(in, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public XMLResolver getXMLResolver() {
        return null;
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
    }

    @Override
    public XMLReporter getXMLReporter() {
        return null;
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (!DEFINITION_PROPERTY.equals(name)) {
            throw new IllegalArgumentException(String.format("Invalid property %s", name));
        }
        this.props.put(name, (WbXmlDefinition)value);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (!this.isPropertySupported(name)) {
            throw new IllegalArgumentException(String.format("Invalid property %s", name));
        }
        return this.props.get(name);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return DEFINITION_PROPERTY.equals(name);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return null;
    }
}

