/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.stream.WbXmlEventWriter;
import es.rickyepoderi.wbxml.stream.WbXmlStreamWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class WbXmlOutputFactory
extends XMLOutputFactory {
    public static String ENCODING_TYPE_PROPERTY = "es.rickyepoderi.wbxml.stream.encodingType";
    public static String SKIP_SPACES_PROPERTY = "es.rickyepoderi.wbxml.stream.skipSpaces";
    public static String DEFINITION_PROPERTY = "es.rickyepoderi.wbxml.stream.definition";
    private Map<String, Object> props = new HashMap<String, Object>();

    public WbXmlOutputFactory() {
        this.props.put(ENCODING_TYPE_PROPERTY, (Object)WbXmlEncoder.StrtblType.IF_NEEDED);
        this.props.put(SKIP_SPACES_PROPERTY, Boolean.TRUE);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        throw new XMLStreamException("The WBXML is a binary format!");
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return new WbXmlStreamWriter(out, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY), (WbXmlEncoder.StrtblType)((Object)this.props.get(ENCODING_TYPE_PROPERTY)), (Boolean)this.props.get(SKIP_SPACES_PROPERTY));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) throws XMLStreamException {
        return new WbXmlStreamWriter(out, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY), (WbXmlEncoder.StrtblType)((Object)this.props.get(ENCODING_TYPE_PROPERTY)), (Boolean)this.props.get(SKIP_SPACES_PROPERTY), encoding);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        try {
            if (result instanceof StreamResult) {
                return new WbXmlStreamWriter(new FileOutputStream(result.getSystemId()), (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY), (WbXmlEncoder.StrtblType)((Object)this.props.get(ENCODING_TYPE_PROPERTY)), (Boolean)this.props.get(SKIP_SPACES_PROPERTY));
            }
            throw new XMLStreamException("WBXML only support StreamResult!");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        try {
            if (result instanceof StreamResult) {
                return new WbXmlEventWriter(new FileOutputStream(result.getSystemId()), (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY), (WbXmlEncoder.StrtblType)((Object)this.props.get(ENCODING_TYPE_PROPERTY)), (Boolean)this.props.get(SKIP_SPACES_PROPERTY));
            }
            throw new XMLStreamException("WBXML only support StreamResult!");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream out) throws XMLStreamException {
        return new WbXmlEventWriter(out, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY), (WbXmlEncoder.StrtblType)((Object)this.props.get(ENCODING_TYPE_PROPERTY)), (Boolean)this.props.get(SKIP_SPACES_PROPERTY));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream out, String encoding) throws XMLStreamException {
        return new WbXmlEventWriter(out, (WbXmlDefinition)this.props.get(DEFINITION_PROPERTY), (WbXmlEncoder.StrtblType)((Object)this.props.get(ENCODING_TYPE_PROPERTY)), (Boolean)this.props.get(SKIP_SPACES_PROPERTY), encoding);
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        throw new XMLStreamException("The WBXML is a binary format!");
    }

    @Override
    public void setProperty(String prop, Object value) throws IllegalArgumentException, ClassCastException {
        if (DEFINITION_PROPERTY.equals(prop)) {
            this.props.put(prop, (WbXmlDefinition)value);
        } else if (SKIP_SPACES_PROPERTY.equals(prop)) {
            this.props.put(prop, (Boolean)value);
        } else if (ENCODING_TYPE_PROPERTY.equals(prop)) {
            this.props.put(ENCODING_TYPE_PROPERTY, (Object)((WbXmlEncoder.StrtblType)((Object)value)));
        } else {
            throw new IllegalArgumentException(String.format("Invalid property %s", prop));
        }
    }

    @Override
    public Object getProperty(String prop) throws IllegalArgumentException {
        if (!this.isPropertySupported(prop)) {
            throw new IllegalArgumentException(String.format("Invalid property %s", prop));
        }
        return this.props.get(prop);
    }

    @Override
    public boolean isPropertySupported(String prop) {
        return DEFINITION_PROPERTY.equals(prop) || SKIP_SPACES_PROPERTY.equals(prop) || ENCODING_TYPE_PROPERTY.equals(prop);
    }
}

