/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream.events;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import es.rickyepoderi.wbxml.stream.events.WbXmlCharactersEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlEndElementEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlStartElementEvent;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WbXmlEvent
implements XMLEvent {
    private int eventType = -1;
    private WbXmlDefinition definition = null;
    private Location loc = null;

    public WbXmlEvent(WbXmlStreamReader stream) {
        this.eventType = stream.getEventType();
        this.definition = stream.getParser().getDefinition();
        this.loc = stream.getLocation();
    }

    protected WbXmlEvent(WbXmlStreamReader stream, int eventType) {
        this(stream);
        this.eventType = eventType;
    }

    protected WbXmlDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public boolean isStartElement() {
        return this.eventType == 1;
    }

    @Override
    public boolean isAttribute() {
        return this.eventType == 10;
    }

    @Override
    public boolean isNamespace() {
        return this.eventType == 13;
    }

    @Override
    public boolean isEndElement() {
        return this.eventType == 2;
    }

    @Override
    public boolean isEntityReference() {
        return this.eventType == 9;
    }

    @Override
    public boolean isProcessingInstruction() {
        return this.eventType == 3;
    }

    @Override
    public boolean isCharacters() {
        return this.eventType == 4 || this.eventType == 12;
    }

    @Override
    public boolean isStartDocument() {
        return this.eventType == 7;
    }

    @Override
    public boolean isEndDocument() {
        return this.eventType == 8;
    }

    @Override
    public StartElement asStartElement() {
        return (WbXmlStartElementEvent)this;
    }

    @Override
    public EndElement asEndElement() {
        return (WbXmlEndElementEvent)this;
    }

    @Override
    public Characters asCharacters() {
        return (WbXmlCharactersEvent)this;
    }

    @Override
    public QName getSchemaType() {
        return null;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
    }

    public Iterator emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator<Object> EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

