/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream.events;

import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.stream.WbXmlStreamReader;
import es.rickyepoderi.wbxml.stream.events.WbXmlAttributeEvent;
import es.rickyepoderi.wbxml.stream.events.WbXmlEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class WbXmlStartElementEvent
extends WbXmlEvent
implements StartElement {
    private WbXmlElement element = null;
    private NamespaceContext nsctx = null;
    List<WbXmlAttributeEvent> attrs = null;

    public WbXmlStartElementEvent(WbXmlStreamReader stream) {
        super(stream);
        if (this.getEventType() != 1) {
            throw new IllegalStateException("Not at START_ELEMENT position!");
        }
        this.element = stream.getCurrentElement();
        this.nsctx = stream.getNamespaceContext();
        this.attrs = new ArrayList<WbXmlAttributeEvent>(this.element.getAttributes().size());
        for (WbXmlAttribute attr : this.element.getAttributes()) {
            WbXmlAttributeEvent event = new WbXmlAttributeEvent(attr, stream);
            this.attrs.add(event);
        }
    }

    @Override
    public QName getName() {
        QName name;
        if (this.element.isPrefixed()) {
            String namespaceUri = this.getDefinition().getNamespaceURIWithLinked(this.element.getTagPrefix());
            name = new QName(namespaceUri, this.element.getTagWithoutPrefix(), this.element.getTagPrefix());
        } else {
            name = new QName(this.element.getTag());
        }
        return name;
    }

    public Iterator getAttributes() {
        return this.attrs.iterator();
    }

    public Iterator getNamespaces() {
        return this.emptyIterator();
    }

    @Override
    public Attribute getAttributeByName(QName qname) {
        Iterator i = this.getAttributes();
        while (i.hasNext()) {
            WbXmlAttributeEvent event = (WbXmlAttributeEvent)i.next();
            if (!qname.equals(event.getName())) continue;
            return event;
        }
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.nsctx;
    }

    @Override
    public String getNamespaceURI(String namespaceURI) {
        return this.nsctx.getPrefix(namespaceURI);
    }

    public String toString() {
        return "StartElement: " + this.element;
    }
}

