/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import com.zx.sms.BaseMessage;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.connect.manager.EndpointEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowSizeChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final Logger logger = LoggerFactory.getLogger(WindowSizeChannelTrafficShapingHandler.class);
    private final ArrayDeque<ToSend> messagesQueue = new ArrayDeque();
    private long queueSize;
    private EndpointEntity entity;
    private boolean useWindow = true;
    private ScheduledFuture sf;
    private Future readFuture;
    private Future submitFuture;
    private ScheduledFuture logFuture;

    public WindowSizeChannelTrafficShapingHandler(EndpointEntity entity, long checkInterval) {
        super((long)entity.getWriteLimit(), (long)entity.getReadLimit(), checkInterval);
        this.setMaxWriteSize((entity.getWriteLimit() > 0 ? entity.getWriteLimit() : 250) * 2);
        this.setMaxWriteDelay(1000L);
        this.entity = entity;
        this.useWindow = entity.getWindow() >= 1;
    }

    public void handlerAdded(final ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(GlobalConstance.SENDWINDOWKEY).set((Object)new AtomicInteger(this.entity.getWindow()));
        TrafficCounter trafficCounter = new TrafficCounter((AbstractTrafficShapingHandler)this, (ScheduledExecutorService)ctx.executor(), "ChannelTC" + ctx.channel().hashCode(), this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
        this.sf = ctx.executor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                WindowSizeChannelTrafficShapingHandler.this.sendAllValid(ctx, TrafficCounter.milliSecondFromNano());
            }
        }, 3L, 1500L, TimeUnit.MILLISECONDS);
        super.handlerAdded(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(GlobalConstance.SENDWINDOWKEY).set(null);
        this.trafficCounter.stop();
        WindowSizeChannelTrafficShapingHandler windowSizeChannelTrafficShapingHandler = this;
        synchronized (windowSizeChannelTrafficShapingHandler) {
            if (ctx.channel().isActive()) {
                for (ToSend toSend : this.messagesQueue) {
                    long size = this.calculateSize(toSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    this.queueSize -= size;
                    ctx.write(toSend.toSend, toSend.promise);
                }
            } else {
                for (ToSend toSend : this.messagesQueue) {
                    if (toSend.toSend instanceof ByteBuf) {
                        ((ByteBuf)toSend.toSend).release();
                    }
                    toSend.promise.tryFailure((Throwable)new IOException("channel InActive.failed by WindowSizeChannelTrafficShapingHandler."));
                }
            }
            this.messagesQueue.clear();
        }
        this.releaseWriteSuspended(ctx);
        this.releaseReadSuspended(ctx);
        if (this.sf != null && !this.sf.isCancelled()) {
            this.sf.cancel(false);
        }
        super.handlerRemoved(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitWrite(final ChannelHandlerContext ctx, Object msg, long size, long delay, long now, ChannelPromise promise) {
        ToSend newToSend;
        Object req;
        if (msg instanceof BaseMessage && !(req = (BaseMessage)msg).isRequest()) {
            ctx.write(msg, promise);
            return;
        }
        req = this;
        synchronized (req) {
            if (delay == 0L && this.allowSendMsg(ctx) && this.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(size);
                this.writeAndDecrement(ctx, msg, promise);
                return;
            }
            newToSend = new ToSend(delay + now, msg, promise);
            this.messagesQueue.addLast(newToSend);
            this.queueSize += size;
            this.checkWriteSuspend(ctx, delay, this.queueSize);
        }
        final long futureNow = newToSend.relativeTimeAction;
        if (delay > 10L) {
            ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    WindowSizeChannelTrafficShapingHandler.this.sendAllValid(ctx, futureNow);
                }
            }, delay, TimeUnit.MILLISECONDS);
        } else if (this.submitFuture == null || this.submitFuture.isDone()) {
            this.submitFuture = ctx.executor().submit(new Runnable(){

                @Override
                public void run() {
                    WindowSizeChannelTrafficShapingHandler.this.sendAllValid(ctx, futureNow);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(final ChannelHandlerContext ctx, long now) {
        WindowSizeChannelTrafficShapingHandler windowSizeChannelTrafficShapingHandler = this;
        synchronized (windowSizeChannelTrafficShapingHandler) {
            ToSend newToSend = this.messagesQueue.pollFirst();
            while (newToSend != null) {
                if (newToSend.relativeTimeAction <= now && this.allowSendMsg(ctx)) {
                    long size = this.calculateSize(newToSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    this.queueSize -= size;
                } else {
                    this.messagesQueue.addFirst(newToSend);
                    break;
                }
                this.writeAndDecrement(ctx, newToSend.toSend, newToSend.promise);
                newToSend = this.messagesQueue.pollFirst();
            }
            if (this.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
        if (this.queueSize > this.getMaxWriteSize() * 2L) {
            final long t_size = this.queueSize;
            final long time = CachedMillisecondClock.INS.now();
            if (this.logFuture == null || this.logFuture.isDone()) {
                this.logFuture = ctx.executor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        logger.warn("time : {} ,ch: {}-{} ,messagesQueue contain message more than : {}", new Object[]{DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(time), WindowSizeChannelTrafficShapingHandler.this.entity.getId(), ctx.channel().id(), t_size});
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
        }
        ctx.flush();
    }

    public long queueSize() {
        return this.queueSize;
    }

    protected long calculateSize(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return this.doCalculateSize(msg);
    }

    private long doCalculateSize(Object msg) {
        if (msg instanceof BaseMessage) {
            BaseMessage req = (BaseMessage)msg;
            if (req.isRequest()) {
                return 1L;
            }
            return 0L;
        }
        return -1L;
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        BaseMessage req;
        if (msg instanceof BaseMessage && (req = (BaseMessage)msg).isResponse() && (this.readFuture == null || this.readFuture.isDone())) {
            this.readFuture = ctx.executor().submit(new Runnable(){

                @Override
                public void run() {
                    WindowSizeChannelTrafficShapingHandler.this.sendAllValid(ctx, TrafficCounter.milliSecondFromNano());
                }
            });
        }
        super.channelRead(ctx, msg);
    }

    private void writeAndDecrement(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        BaseMessage req;
        ctx.write(msg, promise);
        if (msg instanceof BaseMessage && (req = (BaseMessage)msg).isRequest()) {
            this.decrementSendWindow(ctx);
        }
    }

    private void decrementSendWindow(ChannelHandlerContext ctx) {
        AtomicInteger ati = (AtomicInteger)ctx.channel().attr(GlobalConstance.SENDWINDOWKEY).get();
        if (ati != null) {
            ati.decrementAndGet();
        }
    }

    private int getSendWindow(ChannelHandlerContext ctx) {
        AtomicInteger ati = (AtomicInteger)ctx.channel().attr(GlobalConstance.SENDWINDOWKEY).get();
        if (ati != null) {
            return ati.get();
        }
        return -1;
    }

    private boolean allowSendMsg(ChannelHandlerContext ctx) {
        return !this.useWindow || this.getSendWindow(ctx) > 0;
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final ChannelPromise promise;

        private ToSend(long delay, Object toSend, ChannelPromise promise) {
            this.relativeTimeAction = delay;
            this.toSend = toSend;
            this.promise = promise;
        }
    }
}

