/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import org.marre.sms.AbstractSmsDcs;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsMsgClass;

public class SmppSmsDcs
extends AbstractSmsDcs {
    private static final long serialVersionUID = 1L;
    private SmsAlphabet defaultSmsAlphabet = SmsAlphabet.GSM;

    public SmppSmsDcs(byte dcs) {
        super(dcs);
    }

    public SmppSmsDcs(byte dcs, SmsAlphabet defa) {
        super(dcs);
        this.defaultSmsAlphabet = defa;
    }

    public static SmppSmsDcs getGeneralDataCodingDcs(SmsAlphabet alphabet, SmsMsgClass messageClass) {
        byte dcs = 0;
        switch (alphabet) {
            case ASCII: {
                dcs = (byte)(dcs | 1);
                break;
            }
            case GSM: {
                dcs = (byte)(dcs | 0);
                break;
            }
            case LATIN1: {
                dcs = (byte)(dcs | 4);
                break;
            }
            case UCS2: {
                dcs = (byte)(dcs | 8);
                break;
            }
            case RESERVED: {
                dcs = (byte)(dcs | 0xC);
            }
        }
        dcs = SmppSmsDcs.setMessageClass(dcs, messageClass);
        return new SmppSmsDcs(dcs);
    }

    @Override
    public SmsAlphabet getAlphabet() {
        switch (this.getGroup()) {
            case GENERAL_DATA_CODING: 
            case MSG_MARK_AUTO_DELETE: 
            case MESSAGE_WAITING_DISCARD: {
                switch (this.dcs_) {
                    case 0: {
                        return this.defaultSmsAlphabet;
                    }
                    case 1: {
                        return SmsAlphabet.ASCII;
                    }
                    case 3: {
                        return SmsAlphabet.LATIN1;
                    }
                    case 4: {
                        return SmsAlphabet.LATIN1;
                    }
                    case 8: {
                        return SmsAlphabet.UCS2;
                    }
                    case 15: {
                        return SmsAlphabet.RESERVED;
                    }
                }
                switch (this.dcs_ & 0xC) {
                    case 0: {
                        return this.defaultSmsAlphabet;
                    }
                    case 4: {
                        return SmsAlphabet.LATIN1;
                    }
                    case 8: {
                        return SmsAlphabet.UCS2;
                    }
                    case 12: {
                        return SmsAlphabet.RESERVED;
                    }
                }
                return SmsAlphabet.UCS2;
            }
            case MESSAGE_WAITING_STORE_GSM: {
                return this.defaultSmsAlphabet;
            }
            case MESSAGE_WAITING_STORE_UCS2: {
                return SmsAlphabet.UCS2;
            }
            case DATA_CODING_MESSAGE: {
                switch (this.dcs_ & 4) {
                    case 0: {
                        return this.defaultSmsAlphabet;
                    }
                    case 4: {
                        return SmsAlphabet.LATIN1;
                    }
                }
                return SmsAlphabet.UCS2;
            }
        }
        return SmsAlphabet.UCS2;
    }

    @Override
    public int getMaxMsglength() {
        switch (this.getAlphabet()) {
            case GSM: {
                return 159;
            }
        }
        return 140;
    }

    public SmppSmsDcs create(SmsAlphabet alphabet, SmsMsgClass messageClass) {
        SmppSmsDcs dcs = SmppSmsDcs.getGeneralDataCodingDcs(alphabet, messageClass);
        return new SmppSmsDcs(dcs.getValue(), this.defaultSmsAlphabet);
    }
}

