/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.config.PropertiesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.marre.sms.AbstractSmsDcs;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmsConcatMessage
implements SmsMessage {
    private static final Logger logger = LoggerFactory.getLogger(SmsConcatMessage.class);
    private static final AtomicInteger rnd_ = new AtomicInteger(new Random().nextInt(65535));
    private static final Boolean Use8bit = GlobalConstance.Use8bitSmsConcatMessage;
    private String seqNoKey;
    private static final Integer refNoCacheTimeOut = Integer.valueOf(PropertiesUtils.getproperties("refNoCacheTimeOut", "60"));
    private static final LoadingCache<String, AtomicInteger> refNoCache = CacheBuilder.newBuilder().expireAfterAccess((long)refNoCacheTimeOut.intValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

        public AtomicInteger load(String telephone) throws Exception {
            return new AtomicInteger(rnd_.incrementAndGet());
        }
    });

    protected SmsConcatMessage() {
    }

    public abstract SmsUserData getUserData();

    public abstract SmsUdhElement[] getUdhElements();

    private int nextRandom() {
        if (StringUtils.isEmpty((CharSequence)this.seqNoKey)) {
            return rnd_.incrementAndGet() & 0xFFFF;
        }
        AtomicInteger tt = (AtomicInteger)refNoCache.getUnchecked((Object)this.seqNoKey);
        return tt.incrementAndGet() & 0xFFFF;
    }

    private SmsPdu[] createPdus(SmsUdhElement[] udhElements, SmsUserData ud, int maxBytes) {
        SmsPdu[] smsPdus = null;
        if (ud.getLength() <= maxBytes) {
            smsPdus = new SmsPdu[]{new SmsPdu(udhElements, ud)};
        } else {
            List<byte[]> slice = this.sliceUd(ud, maxBytes, Use8bit);
            int maxSlicLength = slice.size();
            if (maxSlicLength > 255) {
                logger.error("error SmsConcatMessage pkTotal Number {} .should be less than 256", (Object)maxSlicLength);
                maxSlicLength = 255;
            }
            smsPdus = new SmsPdu[maxSlicLength];
            SmsUdhElement[] pduUdhElements = null;
            if (udhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[udhElements.length + 1];
                System.arraycopy(udhElements, 0, pduUdhElements, 1, udhElements.length);
            }
            int refno = this.nextRandom();
            for (int i = 0; i < smsPdus.length; ++i) {
                byte[] t = slice.get(i);
                pduUdhElements[0] = Use8bit != false ? SmsUdhUtil.get8BitConcatUdh(refno, smsPdus.length, i + 1) : SmsUdhUtil.get16BitConcatUdh(refno, smsPdus.length, i + 1);
                smsPdus[i] = new SmsPdu(pduUdhElements, t, t.length, ud.getDcs());
            }
        }
        return smsPdus;
    }

    private List<byte[]> sliceUd(SmsUserData ud, int maxBytes, boolean use8bit) {
        int oneCopyLength;
        byte[] udbyte = ud.getData();
        int udLength = udbyte.length;
        int nMaxUdLength = use8bit ? maxBytes - 6 : maxBytes - 7;
        ArrayList<byte[]> slice = new ArrayList<byte[]>();
        for (int udOffset = 0; udOffset < udLength; udOffset += oneCopyLength) {
            byte lastByte;
            oneCopyLength = nMaxUdLength;
            if (udOffset + oneCopyLength >= udLength) {
                oneCopyLength = udLength - udOffset;
            } else if ((oneCopyLength & 1) == 1 && SmsAlphabet.UCS2 == ud.getDcs().getAlphabet()) {
                --oneCopyLength;
            } else if (SmsAlphabet.RESERVED == ud.getDcs().getAlphabet()) {
                int oneByteCharCnt = 0;
                for (int k = udOffset; k < udOffset + oneCopyLength; ++k) {
                    if ((udbyte[k] & 0xFFFFFF80) == -128) {
                        ++k;
                        continue;
                    }
                    ++oneByteCharCnt;
                }
                if ((nMaxUdLength + oneByteCharCnt & 1) == 1) {
                    --oneCopyLength;
                }
            } else if (SmsAlphabet.GSM == ud.getDcs().getAlphabet() && 27 == (lastByte = udbyte[udOffset + oneCopyLength - 1])) {
                --oneCopyLength;
            }
            byte[] tmp = new byte[oneCopyLength];
            System.arraycopy(ud.getData(), udOffset, tmp, 0, oneCopyLength);
            slice.add(tmp);
        }
        return slice;
    }

    @Override
    public SmsPdu[] getPdus() {
        SmsUserData ud = this.getUserData();
        AbstractSmsDcs dcs = ud.getDcs();
        SmsUdhElement[] udhElements = this.getUdhElements();
        int udhLength = SmsUdhUtil.getTotalSize(udhElements);
        int nBytesLeft = dcs.getMaxMsglength() - udhLength;
        SmsPdu[] smsPdus = this.createPdus(udhElements, ud, nBytesLeft);
        return smsPdus;
    }

    public void setSeqNoKey(String seqNoKey) {
        this.seqNoKey = seqNoKey;
    }
}

