/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.util.LinkedList;
import org.marre.sms.MwiProfile;
import org.marre.sms.MwiType;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMsgClass;
import org.marre.sms.SmsTextMessage;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhIei;

public class SmsMwiMessage
extends SmsTextMessage {
    protected final LinkedList<MsgWaiting> messages_ = new LinkedList();

    public SmsMwiMessage() {
        this("", SmsAlphabet.LATIN1);
    }

    public SmsMwiMessage(String text) {
        this(text, SmsAlphabet.ASCII);
    }

    public SmsMwiMessage(String text, SmsAlphabet alphabet) {
        super(text, SmsDcs.getGeneralDataCodingDcs(alphabet, SmsMsgClass.CLASS_UNKNOWN));
    }

    public void addMsgWaiting(MwiType type, int count) {
        this.addMsgWaiting(type, count, MwiProfile.ID_1, false);
    }

    public void addMsgWaiting(MwiType type, int count, MwiProfile profile, boolean storeMessage) {
        if (count > 255) {
            count = 255;
        }
        this.messages_.add(new MsgWaiting(type, count, profile, storeMessage));
    }

    protected SmsUdhElement getMessageWaitingUdh(MsgWaiting msgWaiting) {
        byte[] udh = new byte[2];
        switch (msgWaiting.getType()) {
            case VOICE: {
                udh[0] = 0;
                break;
            }
            case FAX: {
                udh[0] = 1;
                break;
            }
            case EMAIL: {
                udh[0] = 2;
                break;
            }
            case VIDEO: {
                udh[0] = 7;
            }
        }
        switch (msgWaiting.getProfile()) {
            case ID_1: {
                udh[0] = (byte)(udh[0] | 0);
                break;
            }
            case ID_2: {
                udh[0] = (byte)(udh[0] | 0x20);
                break;
            }
            case ID_3: {
                udh[0] = (byte)(udh[0] | 0x40);
                break;
            }
            case ID_4: {
                udh[0] = (byte)(udh[0] | 0x60);
            }
        }
        if (msgWaiting.storeMessage()) {
            udh[0] = (byte)(udh[0] | 0xFFFFFF80);
        }
        udh[1] = (byte)(msgWaiting.getCount() & 0xFF);
        return new SmsUdhElement(SmsUdhIei.SPECIAL_MESSAGE, udh);
    }

    @Override
    public SmsUdhElement[] getUdhElements() {
        SmsUdhElement[] udhElements = null;
        int msgCount = this.messages_.size();
        if (msgCount > 0) {
            udhElements = new SmsUdhElement[this.messages_.size()];
            int i = 0;
            for (MsgWaiting msgWaiting : this.messages_) {
                udhElements[i] = this.getMessageWaitingUdh(msgWaiting);
                ++i;
            }
        }
        return udhElements;
    }

    private static class MsgWaiting {
        private final MwiType type_;
        private final int count_;
        private final MwiProfile profile_;
        private final boolean storeMessage_;

        private MsgWaiting(MwiType type, int count, MwiProfile profile, boolean storeMessage) {
            this.type_ = type;
            this.count_ = count;
            this.profile_ = profile;
            this.storeMessage_ = storeMessage;
        }

        int getCount() {
            return this.count_;
        }

        MwiType getType() {
            return this.type_;
        }

        public MwiProfile getProfile() {
            return this.profile_;
        }

        public boolean storeMessage() {
            return this.storeMessage_;
        }
    }
}

