/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.AbstractSmsDcs;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;

public class SmsPdu {
    protected SmsUdhElement[] udhElements_;
    protected SmsUserData ud_;

    public SmsPdu() {
    }

    public SmsPdu(SmsUdhElement[] udhElements, byte[] ud, int udLength, AbstractSmsDcs dcs) {
        this.setUserDataHeaders(udhElements);
        this.setUserData(ud, udLength, dcs);
    }

    public SmsPdu(SmsUdhElement[] udhElements, SmsUserData ud) {
        this.setUserDataHeaders(udhElements);
        this.setUserData(ud);
    }

    public void setUserDataHeaders(SmsUdhElement[] udhElements) {
        if (udhElements != null) {
            this.udhElements_ = new SmsUdhElement[udhElements.length];
            System.arraycopy(udhElements, 0, this.udhElements_, 0, udhElements.length);
        } else {
            this.udhElements_ = null;
        }
    }

    public SmsUdhElement[] getUdhElements_() {
        return this.udhElements_;
    }

    public byte[] getUserDataHeaders() {
        if (this.udhElements_ == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        byte length = (byte)SmsUdhUtil.getTotalSize(this.udhElements_);
        if (length > 0) {
            baos.write(length);
            try {
                for (SmsUdhElement anUdhElements_ : this.udhElements_) {
                    anUdhElements_.writeTo(baos);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to write to ByteArrayOutputStream");
            }
        }
        return baos.toByteArray();
    }

    public void setUserData(byte[] ud, int udLength, AbstractSmsDcs dcs) {
        this.ud_ = new SmsUserData(ud, udLength, dcs);
    }

    public void setUserData(SmsUserData ud) {
        this.ud_ = ud;
    }

    public SmsUserData getUserData() {
        return this.ud_;
    }

    public AbstractSmsDcs getDcs() {
        return this.ud_.getDcs();
    }
}

