/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

public final class SmsUdhIei {
    public static final SmsUdhIei CONCATENATED_8BIT = new SmsUdhIei(0, "CONCATENATED_8BIT");
    public static final SmsUdhIei SPECIAL_MESSAGE = new SmsUdhIei(1, "SPECIAL_MESSAGE");
    public static final SmsUdhIei APP_PORT_8BIT = new SmsUdhIei(4, "APP_PORT_8BIT");
    public static final SmsUdhIei APP_PORT_16BIT = new SmsUdhIei(5, "APP_PORT_16BIT");
    public static final SmsUdhIei SMSC_CONTROL_PARAMS = new SmsUdhIei(6, "SMSC_CONTROL_PARAMS");
    public static final SmsUdhIei UDH_SOURCE_INDICATOR = new SmsUdhIei(7, "UDH_SOURCE_INDICATOR");
    public static final SmsUdhIei CONCATENATED_16BIT = new SmsUdhIei(8, "CONCATENATED_16BIT");
    public static final SmsUdhIei WCMP = new SmsUdhIei(9, "WCMP");
    public static final SmsUdhIei RFC822_EMAIL_HEADER = new SmsUdhIei(32, "RFC822_EMAIL_HEADER");
    public static final SmsUdhIei HYPERLINK_FORMAT = new SmsUdhIei(33, "HYPERLINK_FORMAT");
    public static final SmsUdhIei COMMAND_PACKET = new SmsUdhIei(112, "(U)SIM Toolkit Security,Headers-Command Packet Identifier.");
    public static final SmsUdhIei COMMAND_RESPONSE_PACKET = new SmsUdhIei(113, "(U)SIM Toolkit Security Headers,Response Packet Identifier.");
    private final byte value;
    private final String name;
    static final String[] InfoEleNameList = new String[]{"0\tConcatenated short messages, 8-bit reference number", "1\tSpecial SMS Message Indication", "2\tReserved", "3\tNot used to avoid misinterpretation as <LF> character", "4\tApplication port addressing scheme, 8 bit address", "5\tApplication port addressing scheme, 16 bit address", "6\tSMSC Control Parameters", "7\tUDH Source Indicator", "8\tConcatenated short message, 16-bit reference number", "9\tWireless Control Message Protocol", "0A\tText Formatting", "0B\tPredefined Sound", "0C\tUser Defined Sound (iMelody\u00a0max 128 bytes)", "0D\tPredefined Animation", "0E\tLarge Animation (16*16 times 4 = 32*4 =128 bytes)", "0F\tSmall Animation (8*8 times 4 = 8*4 =32 bytes)", "10\tLarge Picture (32*32 = 128 bytes)", "11\tSmall Picture (16*16 = 32 bytes)", "12\tVariable Picture", "13\tUser prompt indicator", "14\tExtended Object", "15\tReused Extended Object", "16\tCompression Control", "17\tObject Distribution Indicator", "18\tStandard WVG object", "19\tCharacter Size WVG object", "1A\tExtended Object Data Request Command", "1B\tReserved for future EMS features", "1C\tReserved for future EMS features", "1D\tReserved for future EMS features", "1E\tReserved for future EMS features", "1F\tReserved for future EMS features", "20\tRFC 822\u00a0E-Mail Header", "21\tHyperlink format element", "22\tReply Address Element", "23\tEnhanced Voice Mail Information", "24\tNational Language Single Shift", "25\tNational Language Locking Shift"};

    private SmsUdhIei(byte value, String name) {
        this.value = value;
        this.name = name;
    }

    public static SmsUdhIei valueOf(byte value) {
        switch (value) {
            case 0: {
                return CONCATENATED_8BIT;
            }
            case 1: {
                return SPECIAL_MESSAGE;
            }
            case 4: {
                return APP_PORT_8BIT;
            }
            case 5: {
                return APP_PORT_16BIT;
            }
            case 6: {
                return SMSC_CONTROL_PARAMS;
            }
            case 7: {
                return UDH_SOURCE_INDICATOR;
            }
            case 8: {
                return CONCATENATED_16BIT;
            }
            case 9: {
                return WCMP;
            }
            case 32: {
                return RFC822_EMAIL_HEADER;
            }
            case 33: {
                return HYPERLINK_FORMAT;
            }
            case 112: {
                return COMMAND_PACKET;
            }
            case 113: {
                return COMMAND_RESPONSE_PACKET;
            }
        }
        if (value < InfoEleNameList.length) {
            return new SmsUdhIei(value, InfoEleNameList[value]);
        }
        return new SmsUdhIei(value, String.valueOf(value));
    }

    public byte getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmsUdhIei other = (SmsUdhIei)obj;
        return this.value == other.value;
    }
}

