/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import org.marre.sms.SmsPort;
import org.marre.sms.SmsPortAddressedMessage;
import org.marre.sms.SmsUserData;
import org.marre.sms.nokia.NokiaItemType;
import org.marre.sms.nokia.NokiaPart;

abstract class NokiaMultipartMessage
extends SmsPortAddressedMessage {
    private static final long serialVersionUID = 8558015655242719292L;
    private final LinkedList<NokiaPart> parts_ = new LinkedList();

    protected NokiaMultipartMessage() {
        super(SmsPort.NOKIA_MULTIPART_MESSAGE, SmsPort.ZERO);
    }

    protected void addMultipart(NokiaItemType theItemType, byte[] data) {
        this.parts_.add(new NokiaPart(theItemType, data));
    }

    protected void clear() {
        this.parts_.clear();
    }

    @Override
    public SmsUserData getUserData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(140);
        try {
            baos.write(48);
            for (NokiaPart part : this.parts_) {
                byte[] data = part.getData();
                baos.write(part.getItemType().getTypeId());
                baos.write((byte)(data.length >> 8 & 0xFF));
                baos.write((byte)(data.length & 0xFF));
                baos.write(data);
            }
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return new SmsUserData(baos.toByteArray());
    }
}

