/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsPort;
import org.marre.sms.SmsPortAddressedMessage;
import org.marre.sms.SmsUserData;
import org.marre.sms.nokia.OtaBitmap;

public class NokiaOperatorLogo
extends SmsPortAddressedMessage {
    private static final long serialVersionUID = 8655813384081384243L;
    private boolean discardNokiaHeaders_;
    private final byte[] bitmapData_;
    private final int mcc_;
    private final int mnc_;

    public NokiaOperatorLogo(OtaBitmap otaBitmap, int mcc, int mnc) {
        this(otaBitmap.getBytes(), mcc, mnc);
    }

    public NokiaOperatorLogo(byte[] bitmapData, int mcc, int mnc) {
        super(SmsPort.NOKIA_OPERATOR_LOGO, SmsPort.ZERO);
        this.bitmapData_ = bitmapData;
        this.mcc_ = mcc;
        this.mnc_ = mnc;
    }

    public NokiaOperatorLogo(byte[] bitmapData, int mcc, int mnc, boolean discardHeaders) {
        super(SmsPort.NOKIA_OPERATOR_LOGO, SmsPort.ZERO);
        this.discardNokiaHeaders_ = discardHeaders;
        this.bitmapData_ = bitmapData;
        this.mcc_ = mcc;
        this.mnc_ = mnc;
    }

    @Override
    public SmsUserData getUserData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(140);
        try {
            if (!this.discardNokiaHeaders_) {
                baos.write(48);
            }
            SmsPduUtil.writeBcdNumber(baos, "" + this.mcc_);
            if (this.mnc_ < 10) {
                SmsPduUtil.writeBcdNumber(baos, "0" + this.mnc_);
            } else {
                SmsPduUtil.writeBcdNumber(baos, "" + this.mnc_);
            }
            if (!this.discardNokiaHeaders_) {
                baos.write(10);
            }
            baos.write(this.bitmapData_);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return new SmsUserData(baos.toByteArray());
    }
}

