/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.Serializable;

public class OtaBitmap
implements Serializable {
    private static final long serialVersionUID = -2466133864013197366L;
    private int width_;
    private int height_;
    private byte[] otaImgData_;

    public OtaBitmap(byte[] otaBitmapData) {
        if (otaBitmapData != null) {
            byte infoField = otaBitmapData[0];
            this.width_ = otaBitmapData[1];
            this.height_ = otaBitmapData[2];
            byte depth = otaBitmapData[3];
            int length = otaBitmapData.length - 4;
            this.otaImgData_ = new byte[length];
            System.arraycopy(otaBitmapData, 4, this.otaImgData_, 0, length);
        }
    }

    public OtaBitmap(BufferedImage img) {
        int bitOffset = 0;
        int data = 0;
        int nByte = 0;
        int nTotalBytes = 0;
        Raster raster = img.getData();
        this.width_ = img.getWidth();
        this.height_ = img.getHeight();
        nTotalBytes = this.width_ * this.height_ / 8;
        if (this.width_ * this.height_ % 8 > 0) {
            ++nTotalBytes;
        }
        this.otaImgData_ = new byte[nTotalBytes];
        for (int y = 0; y < this.height_; ++y) {
            for (int x = 0; x < this.width_; ++x) {
                int color = img.getRGB(x, y);
                if (color != 0) {
                    data |= 1 << 7 - bitOffset & 0xFF;
                }
                if (++bitOffset < 8) continue;
                this.otaImgData_[nByte] = (byte)(data & 0xFF);
                bitOffset = 0;
                data = 0;
                ++nByte;
            }
        }
        if (bitOffset > 0) {
            this.otaImgData_[nByte] = (byte)(data & 0xFF);
        }
    }

    public byte[] getImageData() {
        return this.otaImgData_;
    }

    public byte[] getBytes() {
        byte[] otaBitmap = new byte[this.otaImgData_.length + 4];
        otaBitmap[0] = 0;
        otaBitmap[1] = (byte)(this.width_ & 0xFF);
        otaBitmap[2] = (byte)(this.height_ & 0xFF);
        otaBitmap[3] = 1;
        System.arraycopy(this.otaImgData_, 0, otaBitmap, 4, this.otaImgData_.length);
        return otaBitmap;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getWidth() {
        return this.width_;
    }

    public void setHeight(int i) {
        this.height_ = i;
    }

    public void setWidth(int i) {
        this.width_ = i;
    }
}

