/*
 * Decompiled with CFR 0.152.
 */
package org.marre.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BitArrayOutputStream
extends ByteArrayOutputStream {
    private int bitOffset_;
    private int buffer_;

    public BitArrayOutputStream(int size) {
        super(size);
        this.resetBitCounter();
    }

    @Override
    public synchronized byte[] toByteArray() {
        this.flushByte();
        return super.toByteArray();
    }

    private synchronized void resetBitCounter() {
        this.bitOffset_ = 0;
        this.buffer_ = 0;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.resetBitCounter();
    }

    public synchronized void flushByte() {
        if (this.bitOffset_ > 0) {
            super.write(this.buffer_);
            this.resetBitCounter();
        }
    }

    public synchronized void writeBits(byte[] data, int nBits) {
        int bitsLeft = nBits;
        int i = 0;
        while (bitsLeft > 0) {
            this.writeBits(data[i], Math.min(bitsLeft, 8));
            bitsLeft -= 8;
            ++i;
        }
    }

    public synchronized void writeBits(int data, int nBits) {
        int dataLeft = data;
        for (int bitsLeft = nBits; bitsLeft > 0; --bitsLeft) {
            this.writeBit(dataLeft & 1);
            dataLeft >>= 1;
        }
    }

    public synchronized void writeBit(int bit) {
        this.buffer_ |= (bit & 1) << this.bitOffset_;
        ++this.bitOffset_;
        if (this.bitOffset_ == 8) {
            this.flushByte();
        }
    }

    @Override
    public synchronized void write(int data) {
        this.writeBits(data, 8);
    }

    @Override
    public synchronized void write(byte[] data) {
        this.writeBits(data, 8 * data.length);
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) {
        throw new RuntimeException("Not supported yet");
    }

    @Override
    public synchronized void close() throws IOException {
        this.flushByte();
        super.close();
    }
}

