/*
 * Decompiled with CFR 0.152.
 */
package org.marre.util;

import java.util.Random;

public final class StringUtil {
    private static final char[] RANDOM_CHARS = "abcdefghijklmnopqrstuvwxyz1234567890".toCharArray();
    private static final Random rnd_ = new Random();

    private StringUtil() {
    }

    public static int findString(String[] stringTable, String text) {
        if (stringTable != null) {
            for (int i = 0; i < stringTable.length; ++i) {
                if (stringTable[i] == null || !stringTable[i].equals(text)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String bytesToHexString(byte[] data) {
        StringBuilder hexStrBuff = new StringBuilder(data.length * 2);
        for (byte aData : data) {
            String hexByteStr = Integer.toHexString(aData & 0xFF).toUpperCase();
            if (hexByteStr.length() == 1) {
                hexStrBuff.append("0");
            }
            hexStrBuff.append(hexByteStr);
        }
        return hexStrBuff.toString();
    }

    public static String byteToHexString(byte data) {
        StringBuilder hexStrBuff = new StringBuilder(2);
        String hexByteStr = Integer.toHexString(data & 0xFF).toUpperCase();
        if (hexByteStr.length() == 1) {
            hexStrBuff.append("0");
        }
        hexStrBuff.append(hexByteStr);
        return hexStrBuff.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        byte[] data = new byte[hexString.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            String a = hexString.substring(i * 2, i * 2 + 2);
            data[i] = (byte)Integer.parseInt(a, 16);
        }
        return data;
    }

    public static String intToString(int value, int nChars) {
        String strValue = Integer.toString(value);
        StringBuilder strBuf = new StringBuilder(nChars);
        for (int i = strValue.length(); i < nChars; ++i) {
            strBuf.append('0');
        }
        strBuf.append(strValue);
        return strBuf.toString();
    }

    public static String randString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(RANDOM_CHARS[rnd_.nextInt(RANDOM_CHARS.length)]);
        }
        return sb.toString();
    }
}

