/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeMultipart;
import org.marre.mime.encoder.MimeEncoder;
import org.marre.wap.WspEncodingVersion;
import org.marre.wap.WspHeaderEncoder;
import org.marre.wap.WspUtil;

public class WapMimeEncoder
implements MimeEncoder {
    private final WspEncodingVersion wspEncodingVersion_;

    public WapMimeEncoder() {
        this(WspEncodingVersion.VERSION_1_3);
    }

    public WapMimeEncoder(WspEncodingVersion wspEncodingVersion) {
        this.wspEncodingVersion_ = wspEncodingVersion;
    }

    @Override
    public void writeContentType(OutputStream os, MimeBodyPart msg) throws IOException {
        if (msg instanceof MimeMultipart) {
            String ct = msg.getContentType().getValue();
            String newCt = WspUtil.convertMultipartContentType(ct);
            msg.getContentType().setValue(newCt);
        }
        WspUtil.writeContentType(this.wspEncodingVersion_, os, msg.getContentType());
    }

    @Override
    public void writeHeaders(OutputStream os, MimeBodyPart msg) throws IOException {
        for (MimeHeader header : msg.getHeaders()) {
            WspHeaderEncoder.writeHeader(this.wspEncodingVersion_, os, header);
        }
    }

    @Override
    public void writeBody(OutputStream os, MimeBodyPart msg) throws IOException {
        if (msg instanceof MimeMultipart) {
            String ct = msg.getContentType().getValue();
            String newCt = WspUtil.convertMultipartContentType(ct);
            msg.getContentType().setValue(newCt);
            if (newCt.startsWith("application/vnd.wap.multipart.")) {
                this.writeMultipart(os, (MimeMultipart)msg);
            }
        } else {
            os.write(msg.getBody());
        }
    }

    private void writeMultipart(OutputStream os, MimeMultipart multipart) throws IOException {
        Collection<MimeBodyPart> bodyParts = multipart.getBodyParts();
        WspUtil.writeUintvar(os, bodyParts.size());
        for (MimeBodyPart part : bodyParts) {
            ByteArrayOutputStream headers = new ByteArrayOutputStream();
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            this.writeContentType(headers, part);
            this.writeHeaders(headers, part);
            headers.close();
            this.writeBody(content, part);
            content.close();
            WspUtil.writeUintvar(os, headers.size());
            WspUtil.writeUintvar(os, content.size());
            os.write(headers.toByteArray());
            os.write(content.toByteArray());
        }
    }
}

