/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeHeader;
import org.marre.wap.WspEncodingVersion;
import org.marre.wap.WspUtil;

public final class WspHeaderEncoder {
    private WspHeaderEncoder() {
    }

    public static void writeHeader(WspEncodingVersion wspEncodingVersion, OutputStream os, MimeHeader header) throws IOException {
        String headerName = header.getName().toLowerCase();
        int headerType = WspUtil.getHeaderType(headerName);
        switch (headerType) {
            case 0: {
                break;
            }
            case 50: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 51: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 46: {
                break;
            }
            case 60: {
                WspHeaderEncoder.writeHeaderContentID(wspEncodingVersion, os, header.getValue());
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                WspHeaderEncoder.writeHeaderContentLocation(wspEncodingVersion, os, header.getValue());
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                WspHeaderEncoder.writeHeaderContentType(wspEncodingVersion, os, header);
                break;
            }
            case 62: {
                break;
            }
            case 18: {
                break;
            }
            case 63: {
                break;
            }
            case 19: {
                break;
            }
            case 56: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 24: {
                break;
            }
            case 23: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 53: {
                break;
            }
            case 54: {
                break;
            }
            case 55: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 52: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 61: {
                break;
            }
            case 57: {
                break;
            }
            case 58: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 47: {
                WspHeaderEncoder.writeHeaderXWapApplicationId(wspEncodingVersion, os, header.getValue());
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                break;
            }
            case 64: {
                break;
            }
            case 59: {
                break;
            }
            default: {
                WspHeaderEncoder.writeCustomHeader(os, header.getName(), header.getValue());
            }
        }
    }

    public static void writeCustomHeader(OutputStream os, String name, String value) throws IOException {
        WspUtil.writeTokenText(os, name);
        WspUtil.writeTextString(os, value);
    }

    public static void writeHeaderContentID(WspEncodingVersion wspEncodingVersion, OutputStream os, String contentId) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 60);
        if (headerId != -1) {
            WspUtil.writeShortInteger(os, headerId);
            WspUtil.writeQuotedString(os, contentId);
        } else {
            WspHeaderEncoder.writeCustomHeader(os, "Content-ID", contentId);
        }
    }

    public static void writeHeaderContentLocation(WspEncodingVersion wspEncodingVersion, OutputStream os, String contentLocation) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 14);
        WspUtil.writeShortInteger(os, headerId);
        WspUtil.writeTextString(os, contentLocation);
    }

    public static void writeHeaderContentType(WspEncodingVersion wspEncodingVersion, OutputStream os, String contentType) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 17);
        WspUtil.writeShortInteger(os, headerId);
        WspUtil.writeContentType(wspEncodingVersion, os, contentType);
    }

    public static void writeHeaderContentType(WspEncodingVersion wspEncodingVersion, OutputStream os, MimeHeader contentType) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 17);
        WspUtil.writeShortInteger(os, headerId);
        WspUtil.writeContentType(wspEncodingVersion, os, contentType);
    }

    public static void writeHeaderXWapApplicationId(WspEncodingVersion wspEncodingVersion, OutputStream os, String appId) throws IOException {
        int wellKnownAppId = WspUtil.getWellKnownPushAppId(appId.toLowerCase());
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 47);
        if (headerId != -1) {
            WspUtil.writeShortInteger(os, headerId);
            if (wellKnownAppId == -1) {
                WspUtil.writeTextString(os, appId);
            } else {
                WspUtil.writeInteger(os, wellKnownAppId);
            }
        } else {
            WspHeaderEncoder.writeCustomHeader(os, "X-Wap-Application-Id", appId);
        }
    }
}

